//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// SharedFilesCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "SharedFilesCtrl.h"


// CSharedFilesCtrl

IMPLEMENT_DYNAMIC(CSharedFilesCtrl, CListCtrl)
CSharedFilesCtrl::CSharedFilesCtrl(){
	
}

CSharedFilesCtrl::~CSharedFilesCtrl(){
}

void CSharedFilesCtrl::Init(){
	SetExtendedStyle(LVS_EX_FULLROWSELECT);
	InsertColumn(0,"Filename",LVCFMT_LEFT,250,0);
	InsertColumn(1,"Size",LVCFMT_LEFT,100,1);
	InsertColumn(2,"Type",LVCFMT_LEFT,50,2);
	InsertColumn(3,"Priority",LVCFMT_LEFT,50,3);
	InsertColumn(4,"Status",LVCFMT_LEFT,100,4);
	InsertColumn(5,"FileID",LVCFMT_LEFT,160,5);
}

void CSharedFilesCtrl::ShowFileList(CSharedFileList* in_sflist){
	DeleteAllItems();
	sflist = in_sflist;
	for (POSITION pos = sflist->list.GetHeadPosition();pos != 0;sflist->list.GetNext(pos))
		ShowFile(sflist->list.GetAt(pos));
	
}

void CSharedFilesCtrl::ShowFile(CKnownFile* file){
	uint32 itemnr = GetItemCount();
	InsertItem(itemnr,file->GetFileName());
	char buffer[50];
	if (file->GetFileSize() < 1024)
		sprintf(buffer,"%i Bytes",file->GetFileSize());
	else if (file->GetFileSize() < 1048576)
		sprintf(buffer,"%i KB",file->GetFileSize()/1024);
	else
		sprintf(buffer,"%.1f MB",(float)file->GetFileSize()/1048576);
	SetItemText(itemnr,1,buffer);
	SetItemText(itemnr,3,"Normal");
	SetItemText(itemnr,4,"Public shared");
	buffer[0] = 0;
	for (uint16 i = 0;i != 16;i++) // hmm I wonder if there is a standart function for this
		sprintf(buffer,"%s%02X",buffer,file->GetFileHash()[i]);
	SetItemText(itemnr,5,buffer);
}

BEGIN_MESSAGE_MAP(CSharedFilesCtrl, CListCtrl)
END_MESSAGE_MAP()



// CSharedFilesCtrl message handlers

