//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// ServerWnd.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "ServerWnd.h"


// CServerWnd dialog

IMPLEMENT_DYNAMIC(CServerWnd, CDialog)
CServerWnd::CServerWnd(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CServerWnd::IDD, pParent) {
}

CServerWnd::~CServerWnd(){
}

BOOL CServerWnd::OnInitDialog(){
	CResizableDialog::OnInitDialog();
	SetWindowLong(GetDlgItem(IDC_IPADDRESS)->m_hWnd,GWL_STYLE,WS_CHILD|WS_VISIBLE);
	SetWindowLong(GetDlgItem(IDC_IPADDRESS)->m_hWnd,GWL_EXSTYLE,WS_EX_STATICEDGE);
	serverlistctrl.Init(theApp.serverlist);
	((CEdit*)GetDlgItem(IDC_SPORT))->SetLimitText(5);
	GetDlgItem(IDC_SPORT)->SetWindowText("4661");
	servermsgbox.CreateEx(WS_EX_STATICEDGE,0,"MsgWnd",WS_VISIBLE | WS_CHILD | HTC_WORDWRAP |HTC_AUTO_SCROLL_BARS | HTC_UNDERLINE_HOVER,7,235,539,120,this->m_hWnd,0);

	ShowSizeGrip(FALSE);
	AddAnchor(IDC_SERVLIST,TOP_LEFT,CSize(100,34));
	AddAnchor(IDC_SERVINF_TEXT,CSize(0,34));
	AddAnchor(servermsgbox,CSize(0,34),CSize(100,60));
	AddAnchor(IDC_LOG_TEXT,CSize(0,60));
	AddAnchor(IDC_LOGBOX,CSize(0,60),BOTTOM_RIGHT);
	AddAnchor(IDC_SSTATIC,TOP_RIGHT);
	AddAnchor(IDC_SSTATIC2,TOP_RIGHT);
	AddAnchor(IDC_IPADDRESS,TOP_RIGHT);
	AddAnchor(IDC_SSTATIC3,TOP_RIGHT);
	AddAnchor(IDC_SNAME,TOP_RIGHT);
	AddAnchor(IDC_ADDSERVER,TOP_RIGHT);
	AddAnchor(IDC_SBUTTON1,TOP_RIGHT);
	AddAnchor(IDC_SSTATIC4,TOP_RIGHT);
	AddAnchor(IDC_SSTATIC5,TOP_RIGHT);
	AddAnchor(IDC_SPORT,TOP_RIGHT);

	return true;
}

void CServerWnd::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SERVLIST, serverlistctrl);
//	DDX_Control(pDX, IDC_EDIT1, servermsgbox);
	
	DDX_Control(pDX, IDC_LOGBOX, logbox);
}


BEGIN_MESSAGE_MAP(CServerWnd, CResizableDialog)
	ON_BN_CLICKED(IDC_ADDSERVER, OnBnClickedAddserver)
END_MESSAGE_MAP()


// CServerWnd message handlers

void CServerWnd::OnBnClickedAddserver(){
	int8 tmpip[4];
	if ( ((CIPAddressCtrl*)GetDlgItem(IDC_IPADDRESS))->GetAddress(tmpip[0],tmpip[1],tmpip[2],tmpip[3]) != 4){
		MessageBox("Please enter a valid IP","Incomplete IP Address",64);
		return;
	}
	uint32 serverip;
	memcpy(&serverip,tmpip,4);
	if (!GetDlgItem(IDC_SPORT)->GetWindowTextLength()){
		MessageBox("Please enter a serverport","Incomplete serverport",64);
		return;
	}
	char portstr[5];
	GetDlgItem(IDC_SPORT)->GetWindowText(portstr,5);
	CServer* toadd = new CServer(atoi(portstr),serverip);

	int32 namelen = GetDlgItem(IDC_SNAME)->GetWindowTextLength();
	if (namelen){
		char* servername = new char[namelen+2];
		GetDlgItem(IDC_SNAME)->GetWindowText(servername,namelen+1);
		toadd->SetListName(servername);
	}
	else{
		char* servername = new char[24];
		in_addr sip;
		sip.S_un.S_addr = serverip;
		sprintf(servername,"Server %s",inet_ntoa(sip));
		toadd->SetListName(servername);
	}
	serverlistctrl.AddServer(toadd,true);
}
