//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "packets.h"
#include "serversocket.h"
#include "emuleDlg.h"
#include "opcodes.h"
#include "searchlist.h"
#include <time.h>
#include <afxmt.h>


CServerSocket::CServerSocket(CServerConnect* in_serverconnect){
	serverconnect = in_serverconnect;
	headercomplete = false;
	connectionstate = 0;
	sizereceived = 0;
	sizetoget = 0;
	cur_server = 0;
	rbuffer = 0;
}

void CServerSocket::OnConnect(int nErrorCode){
	CAsyncSocket::OnConnect(nErrorCode);
	switch (nErrorCode){
		case 0:
			SetConnectionState(CS_WAITFORLOGIN);
			break;
		case WSAEADDRNOTAVAIL:
		case WSAECONNREFUSED:
		case WSAENETUNREACH:
		case WSAETIMEDOUT: 	
		case WSAEADDRINUSE:
			SetConnectionState(CS_SERVERDEAD);
			return;
		default:	
			SetConnectionState(CS_FATALERROR);
			return;
	}	 
}

void CServerSocket::OnReceive(int nErrorCode){
	if (connectionstate != CS_CONNECTED && !this->serverconnect->IsConnecting()){
		Close();
		return;
	}
	if  (!sizetoget || !headercomplete){
		if (!sizetoget){
			if (rbuffer)
				delete[] rbuffer;
			rbuffer = new char[5];
			headercomplete = false;
			uint32 read = this->Receive(rbuffer,5);
			if (read == (uint32)SOCKET_ERROR)
				return;
			sizereceived +=read; 
		}
		else{
			uint32 read = Receive(rbuffer+sizereceived,sizetoget-sizereceived);
			if (read == (uint32)SOCKET_ERROR)
				return;
			sizereceived +=read; 
		}

		if (sizereceived < 5){
			sizetoget = 5;
			return;
		}
		else{
			Header_Struct* header = (Header_Struct*) rbuffer;
			if (header->eDonkeyID != OP_EDONKEYHEADER){
				theApp.emuledlg->AddLogLine(false,"Debug: Error in Server:OnReceive! header invalid");
				// errorcorrection: try to find next header somewhere		
				for (int i = 0;i != 5; i++){
					if (rbuffer[i] == OP_EDONKEYHEADER){
						memmove(rbuffer,rbuffer+i,5-i);
						sizetoget = 5;
						sizereceived = 5-i;
						return;
					}
				}
				delete[] rbuffer;
				rbuffer = 0;
				sizereceived = 0;
				return;
			}
			else {
				headercomplete = true;
				sizetoget = header->packetlength;
				sizereceived = 0;
				delete[] rbuffer;
				rbuffer = 0;
				return;
			}
		}
	}
	else {
		if (!rbuffer || !sizereceived){
			if (rbuffer)
				delete[] rbuffer;
			rbuffer = new char[sizetoget];
		}
		uint32 read = Receive(rbuffer+sizereceived,sizetoget-sizereceived);
		if (read == (uint32)SOCKET_ERROR)
			return;
		sizereceived +=read; 
		if (sizetoget == sizereceived){
			if (!ProcessPacket(rbuffer+1, sizetoget-1, rbuffer[0]))
				return;
			delete[] rbuffer;
			rbuffer = 0;
			sizetoget = 0;
			sizereceived = 0;
	
		}
	}
}

bool CServerSocket::ProcessPacket(char* packet, int32 size, int8 opcode){
	try{
		if (connectionstate != CS_CONNECTED)
			SetConnectionState(CS_CONNECTED);
		switch(opcode){
			case OP_SERVERMESSAGE:{
				char* buffer = new char[size-1];
				memcpy(buffer,&packet[2],size-2);
				buffer[size-2] = 0;
				theApp.emuledlg->AddServerMessageLine(buffer);
				delete[] buffer;
				break;
			}
			case OP_IDCHANGE:{
				if (size != sizeof(LoginAnswer_Struct)){
					throw "Corrupt or invalid loginanswer from server received";
				}
				LoginAnswer_Struct* la = (LoginAnswer_Struct*) packet;
				serverconnect->SetClientID(la->clientid);
				theApp.emuledlg->AddLogLine(false,"New clientid is %o",la->clientid);
				
				break;
			}
			case OP_SEARCHRESULT:{
				theApp.emuledlg->searchwnd.LocalSearchEnd(theApp.searchlist->ProcessSearchanswer(packet,size));
				break;
			}
			case OP_FOUNDSOURCES:{
				CMemFile* sources = new CMemFile((BYTE*)packet,size);
				uchar fileid[16];
				sources->Read(fileid,16);
				if (CPartFile* file = theApp.downloadqueue->GetFileByID(fileid))
					file->AddSources(sources,cur_server->GetIP(), cur_server->GetPort());
				delete sources;
				break;
			}
			case OP_SERVERSTATUS:{
				// FIXME some statuspackets have a different size -> why? structur?
				if (size != 8)
					break;//throw "Invalid status packet";
				uint32 cur_user;
				memcpy(&cur_user,packet,4);
				uint32 cur_files;
				memcpy(&cur_files,packet+4,4);
				cur_server->SetUserCount(cur_user);
				cur_server->SetFileCount(cur_files);
				theApp.emuledlg->ShowUserCount(cur_user);
				break;
			}
			default:
				;
		}
		return true;
	}
	catch(char* error){
		theApp.emuledlg->AddLogLine(false,"Unhandled error while processing packet from server (%s)",error);
		SetConnectionState(CS_DISCONNECTED);
		return false;
	}
}

void CServerSocket::ConnectToServer(CServer* server){
	cur_server = server;
	theApp.emuledlg->AddLogLine(false,"Connecting to %s (%s:%i)...",cur_server->GetListName(),cur_server->GetFullIP(),cur_server->GetPort());
	SetConnectionState(CS_CONNECTING);
	if (!this->Connect(server->GetFullIP(),server->GetPort())){
		int error = this->GetLastError();
		if ( error != WSAEWOULDBLOCK){
			theApp.emuledlg->AddLogLine(false,"Error while connecting to %s (%s:%i)",cur_server->GetListName(),cur_server->GetFullIP(),cur_server->GetPort()); 
			SetConnectionState(CS_FATALERROR);
			return;
		}
	}
	SetConnectionState(CS_CONNECTING);
}

void CServerSocket::OnClose(int nErrorCode){
	CAsyncSocket::OnClose(nErrorCode);
	if (connectionstate == CS_CONNECTING){	 	
		SetConnectionState(CS_SERVERFULL);
	}
	else if (connectionstate == CS_CONNECTED){
		SetConnectionState(CS_DISCONNECTED);		
	}
	else{
		SetConnectionState(CS_NOTCONNECTED);
	}
	
}

void CServerSocket::SetConnectionState(sint8 newstate){
	sint8 oldstate = connectionstate;
	connectionstate = newstate;
	if (newstate < 1){
		serverconnect->ConnectionFailed(this);
	}
	else if (newstate == CS_CONNECTED || newstate == CS_WAITFORLOGIN){
		if (serverconnect)
			serverconnect->ConnectionEstablished(this);
	}
}
