//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// ServerListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "ServerListCtrl.h"

// CServerListCtrl

IMPLEMENT_DYNAMIC(CServerListCtrl, CTreeCtrl)
CServerListCtrl::CServerListCtrl(){
}

bool CServerListCtrl::Init(CServerList* in_list){
	// Set Imagelist
	server_list = in_list;
	imagelist.Create(16,16,ILC_COLOR,0,10);
	imagelist.SetBkColor(RGB(255,255,255));
	imagelist.Add(theApp.LoadIcon(IDI_ICON1));
	this->SetImageList(&imagelist,TVSIL_NORMAL);

	m_ServerMenu.CreatePopupMenu();
	m_ServerMenu.AddMenuTitle("Server");
	m_ServerMenu.AppendMenu(MF_STRING,MP_CONNECTTO, (LPCTSTR)"Connect to this Server");
	return true;
}

CServerListCtrl::~CServerListCtrl() {
}

void CServerListCtrl::ShowServers(){
	DeleteAllItems();
	for(POSITION pos = server_list->list->GetHeadPosition(); pos != NULL;server_list->list->GetNext(pos)) {
		CServer* cur_server = server_list->list->GetAt(pos);
		HTREEITEM rootitem = InsertItem(TVIF_TEXT|TVIF_PARAM,cur_server->GetListName(),0,0,0,0,(LPARAM)cur_server,0,0);
		cur_server->FillWindowTags(this,rootitem);		
	}
}

void CServerListCtrl::AddServer(CServer* toadd,bool addtolist){
	server_list->AddServer(toadd);
	HTREEITEM rootitem = InsertItem(TVIF_TEXT|TVIF_PARAM,toadd->GetListName(),0,0,0,0,(LPARAM)toadd,0,0);
	toadd->FillWindowTags(this,rootitem);
	EnsureVisible(rootitem);
}


BEGIN_MESSAGE_MAP(CServerListCtrl, CTreeCtrl)
	ON_NOTIFY_REFLECT(NM_RCLICK, OnNMRclickServlist)
END_MESSAGE_MAP()



// CServerListCtrl message handlers

void CServerListCtrl::OnNMRclickServlist(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here
	POINT point;
	::GetCursorPos(&point);
	m_ServerMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
	*pResult = 0;
}

BOOL CServerListCtrl::OnCommand(WPARAM wParam,LPARAM lParam ){
	HTREEITEM item= GetSelectedItem();
	if (item){
		if ((!GetParentItem(item)) && GetItemData(item)){
			switch (wParam){
				case MP_CONNECTTO:
					theApp.serverconnect->ConnectToServer((CServer*)GetItemData(item));
					break;
			}
		}
	}
	return true;
}
