//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "server.h"
#include "opcodes.h"
#include "preferences.h"
#include "serverlistctrl.h"
class CServerList
{
	friend class CServerListCtrl;
public:
	CServerList(CPreferences* in_prefs);
	~CServerList(void);
	bool		Init();
	void		AddServer(CServer* in_server)	{list->AddTail(in_server);}
	void		ResetServerPos()	{serverpos = 0;}
	CServer*	GetNextServer(bool ignorebadservers = true);
	CServer*	GetNextSearchServer(bool ignorebadservers = false);
	//CServer*	GetNextSourceServer(bool ignorebadservers = false);
	CServer*	GetServerAt(uint32 pos)	{return list->GetAt(list->FindIndex(pos));}
	uint32		GetServerCount()	{return list->GetCount();}
	CServer*	GetNextServer(CServer* lastserver); // slow
	CServer*	GetServerByIP(uint32 ip);
	bool		BroadCastPacket(Packet* packet); //send Packet to all server in the list
	void		CancelUDPBroadcast();
	void static CALLBACK UDPTimerProc(HWND hwnd, UINT uMsg,UINT_PTR idEvent,DWORD dwTime);
protected:
	void		AutoUpdate();
private:
	void		SendNextPacket();
	void		Sort();
	uint32		serverpos;
	uint32		searchserverpos;
	int8		version;
	uint32		servercount;
	CTypedPtrList<CPtrList, CServer*>*	list;
	CPreferences*	app_prefs;
	uint32		udp_timer;
	POSITION	broadcastpos;
	Packet*		broadcastpacket;
};
