//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "StdAfx.h"
#include "serverlist.h"
#include "emule.h"
#include "HttpDownloadDlg.h"

CServerList::CServerList(CPreferences* in_prefs){
	list = new CTypedPtrList<CPtrList, CServer*>;
	servercount = 0;
	version = 0;
	serverpos = 0;
	searchserverpos = 0;
	app_prefs = in_prefs;
	udp_timer = 0;
}

void CServerList::AutoUpdate(){
	if (app_prefs->adresses_list.IsEmpty()){
		MessageBox(0,"No serverlistadress entry in 'adresses.dat' found. Please paste a valid serverlist address into this file in order to auto-update your serverlist","Unable to retrieve serverlist",64);
		return;
	}
	char* servermet = new char[strlen(app_prefs->GetAppDir())+20];
	char* oldservermet = new char[strlen(app_prefs->GetAppDir())+20];
	sprintf(servermet,"%sserver.met",app_prefs->GetAppDir());
	sprintf(oldservermet,"%sserver_met.old",app_prefs->GetAppDir());
	remove(oldservermet);
	rename(servermet,oldservermet);
	CHttpDownloadDlg download;
	download.m_sURLToDownload = app_prefs->adresses_list.GetHead().GetBuffer();
	download.m_sFileToDownloadInto = servermet;
	if (download.DoModal() == IDOK){
		remove(oldservermet);
	}
	else{
		theApp.emuledlg->AddLogLine(true,"Failed to download the serverlist form %s",app_prefs->adresses_list.GetHead().GetBuffer());
		rename(oldservermet,servermet);
	}
	delete[] servermet;
	delete[] oldservermet;
}

bool CServerList::Init(){
	if (app_prefs->AutoServerlist())
		AutoUpdate();
	// Load Metfile
	char* fullpath = new char[strlen(app_prefs->GetAppDir())+11];
	strcpy(fullpath,app_prefs->GetAppDir());
	strcat(fullpath,"server.met");
	FILE* servermet = fopen(fullpath, "rb");
	delete[] fullpath;
	if (!servermet){
		theApp.emuledlg->AddLogLine(false,"Failed to load server.met!");
		return false;
	}
	version = fgetc(servermet);
	if (version != 0xE0 && version != MET_HEADER){
		fclose(servermet);
		theApp.emuledlg->AddLogLine(false,"Invalid versiontag in server.met (0x%X)!",version);
		return false;
	}
	uint32 fservercount;
	fread(&fservercount,4,1,servermet);
	theApp.emuledlg->AddLogLine(true,"%i servers in server.met found",fservercount);
	ServerMet_Struct sbuffer;	
	for (uint32 j = 0;j != fservercount && !feof(servermet);j++){
		// get server
		fread(&sbuffer,1,sizeof(ServerMet_Struct),servermet);
		CServer* newserver = new CServer(&sbuffer);
		//add tags
		for (uint32 i=0;i != sbuffer.tagcount;i++)
			newserver->AddTagFromFile(servermet);
		// set listname for server
		if (newserver->ServerHasName()){
			newserver->SetListName(strdup(newserver->GetRealName()));
		}
		else {
				char* listname = new char[strlen(newserver->GetFullIP())+8];
				sprintf(listname,"Server %s",newserver->GetFullIP());
				newserver->SetListName(listname);
		}
			this->AddServer(newserver);
	}
	//theApp.emuledlg->AddLogLine(true,"Finished loading server.met");
	fclose(servermet);
	this->Sort();
	theApp.emuledlg->serverwnd.serverlistctrl.ShowServers();
	return true;
}
CServerList::~CServerList(){
	for(POSITION pos = list->GetHeadPosition(); pos != NULL; pos = list->GetHeadPosition()) {
		delete list->GetAt(pos);
		list->RemoveAt(pos);
	}
	delete list;
	if (udp_timer)
		KillTimer(0,udp_timer);
}

void CServerList::Sort(){
	// put server without names to tail
	// TODO: add fav. servers and custom sort-options (scoresystem etc)
	// TODO: rewrite this part
	POSITION pos;
	uint32 j = list->GetCount();
	for(uint32 i = 0; i != j;) {
		pos = list->FindIndex(i);
		if (!list->GetAt(pos)->ServerHasName()){
			list->AddTail(list->GetAt(pos));
			list->RemoveAt(pos);
			j--;
		}
		else
			i++;
   }
}

CServer* CServerList::GetNextServer(bool ignorebadservers){
	CServer* nextserver = 0;
	uint32 i = 0;
	while (!nextserver && i != list->GetCount()){
		nextserver = list->GetAt(list->FindIndex(serverpos));
		serverpos++;
		i++;
		// TODO: Add more option to filter bad server like min ping, min users etc
		//if (nextserver->preferences = ?)
		//	nextserver = 0;
		if (serverpos == list->GetCount())
			serverpos = 0;
	}
	return nextserver;
}

CServer* CServerList::GetNextSearchServer(bool ignorebadservers){
	CServer* nextserver = 0;
	uint32 i = 0;
	while (!nextserver && i != list->GetCount()){
		nextserver = list->GetAt(list->FindIndex(searchserverpos));
		searchserverpos++;
		i++;
		if (searchserverpos == list->GetCount())
			searchserverpos = 0;
	}
	return nextserver;
}

bool CServerList::BroadCastPacket(Packet* packet){ // unused atm . but might be useful later
	if (udp_timer)
		return false;
	udp_timer = SetTimer(0,4322,UDPSEARCHSPEED,CServerList::UDPTimerProc);
	broadcastpos = list->GetHeadPosition();
	broadcastpacket = packet;
	return true;
}

void CServerList::SendNextPacket(){
	if (theApp.listensocket->TooManySockets()){
		KillTimer(0,udp_timer);
		udp_timer = 0;
		delete broadcastpacket;
		return;
	}

	if (broadcastpos != 0){
		CServer* cur_server = list->GetAt(broadcastpos);
		if (cur_server != theApp.serverconnect->GetCurrentServer())
			theApp.serverconnect->SendUDPPacket(broadcastpacket,cur_server->GetFullIP(),false);
		list->GetNext(broadcastpos);
	}
	else{
		KillTimer(0,udp_timer);
		udp_timer = 0;
		delete broadcastpacket;

	}
}

void CServerList::CancelUDPBroadcast(){
	if (udp_timer){
		KillTimer(0,udp_timer);
		udp_timer = 0;
		delete broadcastpacket;
	}
}

void CALLBACK CServerList::UDPTimerProc(HWND hwnd, UINT uMsg,UINT_PTR idEvent,DWORD dwTime){
	theApp.serverlist->SendNextPacket();
}

CServer* CServerList::GetNextServer(CServer* lastserver){
	if (list->IsEmpty())
		return 0;
	if (!lastserver)
		return list->GetHead();
	POSITION pos = list->Find(lastserver);
	if (!pos){
		TRACE("Error: CServerList::GetNextServer");
		return list->GetHead();
	}
	list->GetNext(pos);
	if (!pos)
		return 0;
	else
		return list->GetAt(pos);
}

CServer* CServerList::GetServerByIP(uint32 ip){
	for (POSITION pos = list->GetHeadPosition();pos != 0;list->GetNext(pos)){
		if (ip == list->GetAt(pos)->GetIP())
			return list->GetAt(pos);
	}
	return 0;
}