//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// SearchListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "SearchListCtrl.h"
#include "otherfunctions.h"


// CSearchListCtrl

IMPLEMENT_DYNAMIC(CSearchListCtrl, CListCtrl)
CSearchListCtrl::CSearchListCtrl(){
	memset(&asc_sort,0,6);
}

void CSearchListCtrl::Init(CSearchList* in_searchlist){
	SetExtendedStyle(LVS_EX_FULLROWSELECT);
	searchlist = in_searchlist;
	InsertColumn(0,"Filename",LVCFMT_LEFT,250,0);
	InsertColumn(1,"Size",LVCFMT_LEFT,100,1);
	InsertColumn(2,"Sources",LVCFMT_LEFT,50,2);
	InsertColumn(3,"Availability",LVCFMT_LEFT,70,3);
	InsertColumn(4,"Type",LVCFMT_LEFT,55,4);
	InsertColumn(5,"FileID",LVCFMT_LEFT,190,5);
}

CSearchListCtrl::~CSearchListCtrl(){
}

BEGIN_MESSAGE_MAP(CSearchListCtrl, CListCtrl)
	ON_NOTIFY_REFLECT ( NM_CUSTOMDRAW, OnCustomdraw )
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
END_MESSAGE_MAP()

// CSearchListCtrl message handlers

void CSearchListCtrl::AddResult(CSearchFile* toshow){
	uint32 itemnr = GetItemCount();
	InsertItem(LVIF_TEXT|LVIF_PARAM,itemnr,toshow->GetName(),0,0,1,(LPARAM)toshow);
	uint32 filesize = toshow->GetIntTagValue(FT_FILESIZE); 
	char buffer[50];
	CastItoXBytes(filesize,buffer);
	SetItemText(itemnr,1,buffer);
	itoa(toshow->GetIntTagValue(FT_SOURCES),buffer,10);
	SetItemText(itemnr,2,buffer);
	SetItemText(itemnr,4,toshow->GetStrTagValue(FT_FILETYPE));
	buffer[0] = 0;
	for (uint16 i = 0;i != 16;i++) // hmm I wonder if there is a standart function for this
		sprintf(buffer,"%s%02X",buffer,toshow->GetFileHash()[i]);
	SetItemText(itemnr,5,buffer);
}

void CSearchListCtrl::UpdateSources(CSearchFile* toupdate){
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)toupdate;
	uint16 index = FindItem(&find);
	char buffer[50];
	itoa(toupdate->GetSourceCount(),buffer,10);
	SetItemText(index,2,buffer);
}

void CSearchListCtrl::OnCustomdraw(NMHDR* pNMHDR, LRESULT* pResult ){
NMLVCUSTOMDRAW* pLVCD = reinterpret_cast<NMLVCUSTOMDRAW*>( pNMHDR );

    *pResult = CDRF_DODEFAULT;

    if (CDDS_PREPAINT == pLVCD->nmcd.dwDrawStage){
        *pResult = CDRF_NOTIFYITEMDRAW;
    }
    else if (CDDS_ITEMPREPAINT == pLVCD->nmcd.dwDrawStage){
		uint32 blue = 0;
		CSearchFile* file = (CSearchFile*)pLVCD->nmcd.lItemlParam;
		blue = (file->GetSourceCount()-1) * 22;
		if (blue > 255)
			blue = 255;
        pLVCD->clrText = RGB(0,0,blue);
        *pResult = CDRF_DODEFAULT;
     }
}

void CSearchListCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult){
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// if it's a second click on the same column then reverse the sort order,
	// otherwise sort the new column in ascending order.
	asc_sort[pNMListView->iSubItem] = !asc_sort[pNMListView->iSubItem];
	SortItems(&SortProc,pNMListView->iSubItem+ ((asc_sort[pNMListView->iSubItem])? 0:10));
	*pResult = 0;
}

int CSearchListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort){
	CSearchFile* item1 = (CSearchFile*)lParam1;
	CSearchFile* item2 = (CSearchFile*)lParam2;	
	switch(lParamSort){
		case 0: //filename asc
			return strcmp(item1->GetName(),item2->GetName());
		case 10: //filename desc
			return strcmp(item2->GetName(),item1->GetName());
		case 1: //size asc
			return item2->GetIntTagValue(FT_FILESIZE) - item1->GetIntTagValue(FT_FILESIZE);
		case 11: //size desc
			return item1->GetIntTagValue(FT_FILESIZE) - item2->GetIntTagValue(FT_FILESIZE);
		case 2: //sources asc
			return item2->GetIntTagValue(FT_SOURCES) - item1->GetIntTagValue(FT_SOURCES);
		case 12: //sources desc
			return item1->GetIntTagValue(FT_SOURCES) - item2->GetIntTagValue(FT_SOURCES);
		case 5: //filahash asc
			return memcmp(item1->GetFileHash(),item2->GetFileHash(),16);
		case 15: //filehash desc
			return memcmp(item2->GetFileHash(),item1->GetFileHash(),16);
		default:
			return 0;
	}
}
