//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "opcodes.h"
#include "emule.h"
#include "types.h"
#include "preferences.h"
#include "KnownFile.h"
#include "packets.h"
#include "searchlistctrl.h"

class SearchList;

class CSearchFile {
friend class CPartFile;
public:
	//CSearchFile() {};
	CSearchFile(CFile* in_data);
	~CSearchFile();
	uint32	GetIntTagValue(uint8 tagname);
	char*	GetStrTagValue(uint8 tagname);
	uchar*	GetFileHash()	{return filehash;}
	uint32	AddSources(uint32 count);
	uint32	GetSourceCount();
	char*	GetName()		{return name;}
private:
	char*	name;
	uchar	filehash[16];
	uint8	clientip[4];
	uint16	clientport;
	uint32	filesize;
	uint32	filetype;
	CArray<CTag*,CTag*> taglist;
};

class CSearchList
{
friend class CSearchListCtrl;
public:
	CSearchList();
	~CSearchList();
	void Clear();
	void NewSearch(CSearchListCtrl* in_wnd)	{outputwnd = in_wnd;Clear();}
	uint16 ProcessSearchanswer(char* packet, uint32 size);
	uint16	ProcessUDPSearchanswer(char* packet, uint32 size);
	uint16	GetResultCount();
private:
	void AddToList(CSearchFile* toadd);
	CTypedPtrList<CPtrList, CSearchFile*> list;
	CSearchListCtrl*	outputwnd;
};
