//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "StdAfx.h"
#include "searchlist.h"

CSearchFile::CSearchFile(CFile* in_data){
	in_data->Read(&filehash,16);
	in_data->Read(&clientip,4);
	in_data->Read(&clientport,2);
	uint32 tagcount;
	in_data->Read(&tagcount,4);
	for (int i = 0;i != tagcount; i++){
		CTag* toadd = new CTag(in_data);
		taglist.Add(toadd);
	}
	name = 0;
	name = GetStrTagValue(FT_FILENAME);
	if (!name)
		name = "?";
}
CSearchFile::~CSearchFile(){
	for (int i = 0; i != taglist.GetSize();i++)
		safe_delete(taglist[i]);
	taglist.RemoveAll();
	taglist.SetSize(0);
}

uint32 CSearchFile::GetIntTagValue(uint8 tagname){
	for (int i = 0; i != taglist.GetSize(); i++){
		if (taglist[i]->tag->specialtag == tagname)
			return taglist[i]->tag->intvalue;
	}
	return 0;
}
char* CSearchFile::GetStrTagValue(uint8 tagname){
	for (int i = 0; i != taglist.GetSize(); i++){
		if (taglist[i]->tag->specialtag == tagname)
			return taglist[i]->tag->stringvalue;			
	}
	return 0;
}
uint32 CSearchFile::AddSources(uint32 count){
	for (int i = 0; i != taglist.GetSize(); i++){
		if (taglist[i]->tag->specialtag == FT_SOURCES){
			taglist[i]->tag->intvalue += count;
			return taglist[i]->tag->intvalue;
		}
	}
	return 0;
}
uint32 CSearchFile::GetSourceCount(){
	return GetIntTagValue(FT_SOURCES);
}

CSearchList::CSearchList(){
	outputwnd = 0;
}

CSearchList::~CSearchList(){
	Clear();
}

void CSearchList::Clear(){
	for(POSITION pos = list.GetHeadPosition(); pos != NULL; pos = list.GetHeadPosition()) {
		delete list.GetAt(pos);
		list.RemoveAt(pos);
	}
}

uint16 CSearchList::ProcessSearchanswer(char* in_packet, uint32 size){
	CMemFile* packet = new CMemFile((BYTE*)in_packet,size,0);
	uint32 results;
	packet->Read(&results,4);
	for (int i = 0; i != results; i++){
		CSearchFile* toadd = new CSearchFile(packet);
		AddToList(toadd);
	}
	packet->Close();
	delete packet;
	return GetResultCount();
}

uint16 CSearchList::ProcessUDPSearchanswer(char* in_packet, uint32 size){
	CMemFile* packet = new CMemFile((BYTE*)in_packet,size,0);
	CSearchFile* toadd = new CSearchFile(packet);
	AddToList(toadd);
	packet->Close();
	delete packet;
	return GetResultCount();
}

void CSearchList::AddToList(CSearchFile* toadd){
	uint32 i = 0;
	for (POSITION pos = list.GetHeadPosition(); pos != NULL; list.GetNext(pos)){
		i++;
		if (!memcmp((char*)toadd->GetFileHash(),(char*)list.GetAt(pos)->GetFileHash(),16)){
			list.GetAt(pos)->AddSources(toadd->GetIntTagValue(FT_SOURCES));
			if (outputwnd)
				outputwnd->UpdateSources(list.GetAt(pos));
			return;
		}
	}
	list.AddTail(toadd);
	if (outputwnd)
		outputwnd->AddResult(toadd);
}

uint16 CSearchList::GetResultCount(){
	uint16 hits = 0;
	for (POSITION pos = list.GetHeadPosition(); pos != NULL; list.GetNext(pos))
		hits += list.GetAt(pos)->GetIntTagValue(FT_SOURCES);
	return hits;
}

