//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// SearchDlg.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "SearchDlg.h"
#include "packets.h"
#include "server.h"
#include "opcodes.h"

// CSearchDlg dialog

IMPLEMENT_DYNAMIC(CSearchDlg, CDialog)
CSearchDlg::CSearchDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CSearchDlg::IDD, pParent){
}

CSearchDlg::~CSearchDlg(){
}

BOOL CSearchDlg::OnInitDialog(){
	CResizableDialog::OnInitDialog();
	searchlistctrl.Init(theApp.searchlist);
	searchprogress.SetStep(1);
	global_search_timer = 0;
	globsearch = false;
	ShowSizeGrip(FALSE);
	AddAnchor(IDC_STARTS,TOP_RIGHT);
	AddAnchor(IDC_CANCELS,TOP_RIGHT);
	AddAnchor(IDC_SDOWNLOAD,BOTTOM_RIGHT);
	AddAnchor(IDC_FAKECHECK,BOTTOM_RIGHT);
	AddAnchor(IDC_SEARCHLIST,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_PROGRESS1,BOTTOM_LEFT,BOTTOM_RIGHT);

	return true;
}

void CSearchDlg::DoDataExchange(CDataExchange* pDX){
	CResizableDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SEARCHLIST, searchlistctrl);
	DDX_Control(pDX, IDC_PROGRESS1, searchprogress);
}


BEGIN_MESSAGE_MAP(CSearchDlg, CResizableDialog)
	ON_BN_CLICKED(IDC_STARTS, OnBnClickedStarts)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CANCELS, OnBnClickedCancels)
	ON_BN_CLICKED(IDC_SDOWNLOAD, OnBnClickedSdownload)
	ON_NOTIFY(NM_DBLCLK, IDC_SEARCHLIST, OnNMDblclkSearchlist)
END_MESSAGE_MAP()


// CSearchDlg message handlers

void CSearchDlg::OnBnClickedStarts(){
	if (GetDlgItem(IDC_ELINK)->GetWindowTextLength()){
		CString link;
		GetDlgItem(IDC_ELINK)->GetWindowText(link);
		GetDlgItem(IDC_ELINK)->SetWindowText("");
		theApp.downloadqueue->AddSearchToDownload(link);
		return;
	}
	
	// start search
	if (!theApp.serverconnect->IsConnected())
		MessageBox("Your are not connected to a Server","Not Connected",64);
	else{
		theApp.searchlist->NewSearch(&searchlistctrl);
		searchlistctrl.DeleteAllItems();
		this->GetDlgItem(IDC_STARTS)->EnableWindow(false);
		this->GetDlgItem(IDC_CANCELS)->EnableWindow(true);
		canceld = false;

		CMemFile* data = new CMemFile(100);
		int8 buffer = 1; // hmmmmmm
		data->Write(&buffer,1);
		uint16 size = GetDlgItem(IDC_SEARCHNAME)->GetWindowTextLength();
		data->Write(&size,2);
		char* searchstr = new char[size+1];
		GetDlgItem(IDC_SEARCHNAME)->GetWindowText(searchstr,size+1);
		data->Write(searchstr,size);
		delete[] searchstr;
		Packet* packet = new Packet(OP_SEARCHREQUEST,0);
		packet->size = data->GetLength();
		packet->pBuffer = (char*)data->Detach();
		delete data;
		theApp.serverconnect->SendPacket(packet,false);
		if (this->IsDlgButtonChecked(IDC_SGLOBAL)){
			searchpacket = packet;
			searchpacket->opcode = OP_GLOBSEARCHREQ;
			servercount = 0;
			searchprogress.SetRange32(0,theApp.serverlist->GetServerCount()-1);
			globsearch = true;
		}
		else{
			globsearch = false;
			delete packet;
		}
	}
}

void CSearchDlg::OnTimer(UINT nIDEvent){
	CResizableDialog::OnTimer(nIDEvent);
	CServer* toask = theApp.serverlist->GetNextSearchServer();
	if (toask == theApp.serverconnect->GetCurrentServer())
		toask = theApp.serverlist->GetNextSearchServer();

	if (toask && theApp.serverconnect->IsConnected() && theApp.serverlist->GetServerCount()-1 != servercount){
		servercount++;
		theApp.serverconnect->SendUDPPacket(searchpacket,toask->GetFullIP(),false);
		searchprogress.StepIt();
	}
	else
		OnBnClickedCancels();
}

void CSearchDlg::OnBnClickedCancels(){
	canceld = true;
	globsearch = false;
	if (global_search_timer){
		delete searchpacket;
		KillTimer(global_search_timer);
		global_search_timer = 0;
		searchprogress.SetPos(0);
	}
	this->GetDlgItem(IDC_CANCELS)->EnableWindow(false);
	this->GetDlgItem(IDC_STARTS)->EnableWindow(true);
}

void CSearchDlg::LocalSearchEnd(uint16 count){
	if (!canceld && count > MAX_RESULTS)
		OnBnClickedCancels();
	if (!canceld){	
		if (!globsearch){
			this->GetDlgItem(IDC_STARTS)->EnableWindow(true);
			this->GetDlgItem(IDC_CANCELS)->EnableWindow(false);
		}
		else
			global_search_timer = SetTimer(1, 750, 0);

	}
}
void CSearchDlg::AddUDPResult(uint16 count){
	if (!canceld && count > MAX_RESULTS)
		OnBnClickedCancels();
}

void CSearchDlg::OnBnClickedSdownload(){
	//start download
	if (searchlistctrl.GetSelectionMark() != -1)
		theApp.downloadqueue->AddSearchToDownload((CSearchFile*)searchlistctrl.GetItemData(searchlistctrl.GetSelectionMark()));
}

BOOL CSearchDlg::PreTranslateMessage(MSG* pMsg) 
{
   if((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == 13)){
	   if (pMsg->hwnd == GetDlgItem(IDC_SEARCHLIST)->m_hWnd)
			OnBnClickedSdownload();
	   else if (pMsg->hwnd == GetDlgItem(IDC_ELINK)->m_hWnd)
			OnBnClickedStarts();
	   else if (pMsg->hwnd == GetDlgItem(IDC_SEARCHNAME)->m_hWnd)
			OnBnClickedStarts();
   }

   return CResizableDialog::PreTranslateMessage(pMsg);
}

void CSearchDlg::OnNMDblclkSearchlist(NMHDR *pNMHDR, LRESULT *pResult){
	OnBnClickedSdownload();
	*pResult = 0;
}
