//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// PreferencesWnd.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PreferencesWnd.h"
#include "objbase.h"
#include "Shlobj.h"

// CPreferencesWnd dialog

IMPLEMENT_DYNAMIC(CPreferencesWnd, CDialog)
CPreferencesWnd::CPreferencesWnd(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CPreferencesWnd::IDD, pParent)
{
}

CPreferencesWnd::~CPreferencesWnd()
{
}

void CPreferencesWnd::DoDataExchange(CDataExchange* pDX){
	CResizableDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SDLIST, sdlistbox);
}
bool CPreferencesWnd::Create(UINT nIDTemplate,CPreferences* in_prefs){
	app_prefs = in_prefs;
	return CResizableDialog::Create(nIDTemplate);
}

BOOL CPreferencesWnd::OnInitDialog(){
	CResizableDialog::OnInitDialog();
	listchanged = false;
	((CEdit*)GetDlgItem(IDC_NICK))->SetLimitText(49);
	((CEdit*)GetDlgItem(IDC_INCFILES))->SetLimitText(509);
	((CEdit*)GetDlgItem(IDC_TEMPFILES))->SetLimitText(509);
	LoadSettings();

	ShowSizeGrip(FALSE);
	AddAnchor(IDC_APPLY,BOTTOM_RIGHT);
	AddAnchor(IDC_BUTTON3,BOTTOM_RIGHT);
	return true;
}
void CPreferencesWnd::LoadSettings(){
	switch(app_prefs->prefs->deadserver){
		case 1:
			this->CheckDlgButton(IDC_RADIO1,1);
			break;
		case 2:
			this->CheckDlgButton(IDC_RADIO2,1);
			break;
	}
	GetDlgItem(IDC_NICK)->SetWindowText(app_prefs->prefs->nick);
	GetDlgItem(IDC_INCFILES)->SetWindowText(app_prefs->prefs->incomingdir);
	GetDlgItem(IDC_TEMPFILES)->SetWindowText(app_prefs->prefs->tempdir);
	if (app_prefs->prefs->scorsystem)
		CheckDlgButton(IDC_SCORE,1);
	else
		CheckDlgButton(IDC_SCORE,0);
	if (app_prefs->prefs->reconnect)
		CheckDlgButton(IDC_RECONN,1);
	else
		CheckDlgButton(IDC_RECONN,0);

	if (app_prefs->prefs->ICH)
		CheckDlgButton(IDC_ICH,1);
	else
		CheckDlgButton(IDC_ICH,0);

	if (app_prefs->prefs->autoserverlist)
		CheckDlgButton(IDC_AUTOSERVER,1);
	else
		CheckDlgButton(IDC_AUTOSERVER,0);

	if (app_prefs->prefs->updatenotify)
		CheckDlgButton(IDC_NOTIFY,1);
	else
		CheckDlgButton(IDC_NOTIFY,0);

	if (app_prefs->prefs->mintotray)
		CheckDlgButton(IDC_MINTRAY,1);
	else
		CheckDlgButton(IDC_MINTRAY,0);

	if (app_prefs->prefs->autoconnect)
		CheckDlgButton(IDC_AUTOCONNECT,1);
	else
		CheckDlgButton(IDC_AUTOCONNECT,0);

	char buffer[20];
	memset(&buffer,0,20);

	if (app_prefs->prefs->maxupload == 0xFFFF)
		GetDlgItem(IDC_MAXUP)->SetWindowText("0");
	else{
		itoa(app_prefs->prefs->maxupload,buffer,10);
		GetDlgItem(IDC_MAXUP)->SetWindowText(buffer);
	}
	if (app_prefs->prefs->maxdownload == 0xFFFF)
		GetDlgItem(IDC_MAXDOWN)->SetWindowText("0");
	else{
		itoa(app_prefs->prefs->maxdownload,buffer,10);
		GetDlgItem(IDC_MAXDOWN)->SetWindowText(buffer);
	}
	itoa(app_prefs->prefs->maxconnections,buffer,10);
	GetDlgItem(IDC_MAXCON)->SetWindowText(buffer);
	itoa(app_prefs->prefs->port,buffer,10);
	GetDlgItem(IDC_PORT)->SetWindowText(buffer);
	sdlistbox.ResetContent();
	for (POSITION pos = app_prefs->shareddir_list.GetHeadPosition();pos != 0;app_prefs->shareddir_list.GetNext(pos))
		sdlistbox.AddString(app_prefs->shareddir_list.GetAt(pos).GetBuffer());
}

BEGIN_MESSAGE_MAP(CPreferencesWnd, CResizableDialog)
	ON_BN_CLICKED(IDC_RADIO2, OnBnClickedRadio2)
	ON_BN_CLICKED(IDC_RADIO1, OnBnClickedRadio1)
	ON_BN_CLICKED(IDC_BUTTON3, OnBnClickedButton3)
	ON_BN_CLICKED(IDC_APPLY, OnBnClickedApply)
	ON_BN_CLICKED(IDC_BUTTON8, OnBnClickedButton8)
	ON_BN_CLICKED(IDC_BUTTON7, OnBnClickedButton7)
	ON_BN_CLICKED(IDC_BROWSE1, OnBnClickedBrowse1)
	ON_BN_CLICKED(IDC_BROWSE2, OnBnClickedBrowse2)
END_MESSAGE_MAP()


// CPreferencesWnd message handlers


void CPreferencesWnd::OnBnClickedButton3(){
	LoadSettings();
}

void CPreferencesWnd::OnBnClickedApply(){
	char buffer[510];
	if (GetDlgItem(IDC_NICK)->GetWindowTextLength()){
		GetDlgItem(IDC_NICK)->GetWindowText(buffer,34);
		if (!strstr(buffer,"emule.sf.net")){
			if (MessageBox("Please support eMule by appending [emule.sf.net] onto your username. Do you want to append it now? ","Support eMule",MB_ICONQUESTION|MB_YESNO) == IDYES)
				sprintf(app_prefs->prefs->nick,"%s [emule.sf.net]",buffer);
			else
				strcpy(app_prefs->prefs->nick,buffer);
		}
		else
			strcpy(app_prefs->prefs->nick,buffer);
	}
	if (GetDlgItem(IDC_INCFILES)->GetWindowTextLength()){
		GetDlgItem(IDC_INCFILES)->GetWindowText(buffer,509);
		strcpy(app_prefs->prefs->incomingdir,buffer);
	}
	if (GetDlgItem(IDC_TEMPFILES)->GetWindowTextLength()){
		GetDlgItem(IDC_TEMPFILES)->GetWindowText(buffer,509);
		strcpy(app_prefs->prefs->tempdir,buffer);
	}
	if (GetDlgItem(IDC_MAXUP)->GetWindowTextLength()){
		GetDlgItem(IDC_MAXUP)->GetWindowText(buffer,20);
		app_prefs->prefs->maxupload = (atoi(buffer))? atoi(buffer):0xFFFF;
	}
	if (GetDlgItem(IDC_MAXDOWN)->GetWindowTextLength()){
		GetDlgItem(IDC_MAXDOWN)->GetWindowText(buffer,20);
		app_prefs->prefs->maxdownload = (atoi(buffer))? atoi(buffer):0xFFFF;
	}
	if (GetDlgItem(IDC_MAXCON)->GetWindowTextLength()){
		GetDlgItem(IDC_MAXCON)->GetWindowText(buffer,20);
		app_prefs->prefs->maxconnections = (atoi(buffer))? atoi(buffer):500;
	}
	if (GetDlgItem(IDC_PORT)->GetWindowTextLength()){
		GetDlgItem(IDC_PORT)->GetWindowText(buffer,20);
		app_prefs->prefs->port = (atoi(buffer))? atoi(buffer):4662;
	}
	app_prefs->prefs->scorsystem = (int8)IsDlgButtonChecked(IDC_SCORE);
	app_prefs->prefs->reconnect = (int8)IsDlgButtonChecked(IDC_RECONN);
	app_prefs->prefs->autoserverlist = (int8)IsDlgButtonChecked(IDC_AUTOSERVER);
	app_prefs->prefs->ICH = (int8)IsDlgButtonChecked(IDC_ICH);
	app_prefs->prefs->updatenotify = (int8)IsDlgButtonChecked(IDC_NOTIFY);
	app_prefs->prefs->mintotray = (int8)IsDlgButtonChecked(IDC_MINTRAY);
	app_prefs->prefs->autoconnect = (int8)IsDlgButtonChecked(IDC_AUTOCONNECT);
	if (IsDlgButtonChecked(IDC_RADIO1))
		app_prefs->prefs->deadserver = 1;
	else
		app_prefs->prefs->deadserver = 2;
	if (listchanged){
		listchanged = false;
		app_prefs->shareddir_list.RemoveAll();
		CString toadd;
		for (int i = 0;i != sdlistbox.GetCount(); i++){
			sdlistbox.GetText(i,toadd);
			app_prefs->shareddir_list.AddTail(toadd);
		}
		theApp.sharedfiles->Reload();
	}
	app_prefs->Save();
	this->LoadSettings();
}

void CPreferencesWnd::OnBnClickedButton8(){ // Shared directory remove button
		sdlistbox.DeleteString(sdlistbox.GetCurSel());
		listchanged = true;
}

void CPreferencesWnd::OnBnClickedButton7(){// Shared directory add button
	char buffer[MAX_PATH];
	if (SelectDir(buffer,"Choose a folder. All files in this folder will be shared")){
		sdlistbox.AddString(buffer);
		listchanged = true;
	}
}

bool CPreferencesWnd::SelectDir(char* outdir, char* titletext){
	CoInitialize(0);
	bool done;
	char* buffer = new char[MAX_PATH];
	BROWSEINFO bi = {GetSafeHwnd(),0,buffer,titletext,BIF_VALIDATE|BIF_NEWDIALOGSTYLE|BIF_RETURNONLYFSDIRS,0,0,0};
	LPITEMIDLIST pidl = SHBrowseForFolder(&bi);
	delete[] buffer;
	done = SHGetPathFromIDList(pidl,outdir);
	LPMALLOC ppMalloc;
	if (SHGetMalloc(&ppMalloc) == NOERROR)
		ppMalloc->Free(pidl);
	CoUninitialize();
	return done;
}
void CPreferencesWnd::OnBnClickedBrowse1(){
	char buffer[MAX_PATH];
	if (SelectDir(buffer,"Choose a folder for incoming files")){
		GetDlgItem(IDC_INCFILES)->SetWindowText(buffer);
		listchanged = true;
	}
}

void CPreferencesWnd::OnBnClickedBrowse2(){
	char buffer[MAX_PATH];
	if (SelectDir(buffer,"Choose a folder for temp files"))
		GetDlgItem(IDC_TEMPFILES)->SetWindowText(buffer);
}
