//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "types.h"
#include "opcodes.h"
#include "preferenceswnd.h"

#pragma pack(1)
struct Preferences_Struct{
	int8	version;
	char	nick[50];
	uint16	maxupload;
	uint16	maxdownload;
	uint16	port;
	uint16	maxconnections;
	int8	reconnect;
	int8	deadserver;
	int8	scorsystem;
	char	incomingdir[510];
	char	tempdir[510];
	int8	ICH;
	int8	autoserverlist;
	int8	updatenotify;
	int8	mintotray;
	uchar	userhash[16];
	int8	autoconnect;
};

class CPreferences{
public:
	friend class CPreferencesWnd;
	CPreferences();
	~CPreferences();
	char*	GetAppDir()		{return appdir;}
	bool	Save();

	bool	Reconnect()		{return prefs->reconnect;}
	int8	DeadServer()	{return prefs->deadserver;}
	char*	GetUserNick()	{return prefs->nick;}
	uint16	GetPort()		{return prefs->port;}
	char*	GetIncomingDir(){return prefs->incomingdir;}
	char*	GetTempDir()	{return prefs->tempdir;}
	char*	GetUserHash()	{return userhash;}
	uint16	GetMaxUpload()	{return	prefs->maxupload;}
	bool	IsICHEnabled()	{return prefs->ICH;}
	bool	AutoServerlist(){return prefs->autoserverlist;}
	bool	UpdateNotify()	{return prefs->updatenotify;}
	bool	DoMinToTray()	{return prefs->mintotray;}
	bool	DoAutoConnect() {return prefs->autoconnect;}
	int8*	GetMinTrayPTR() {return &prefs->mintotray;}
	uint16	GetMaxDownload();
	uint16	GetMaxConnections()	{return	prefs->maxconnections;}
	CStringList shareddir_list;
	CStringList adresses_list;
protected:
	void	CreateUserHash();
	void	SetStandartValues();
private:
	char* appdir;
	Preferences_Struct* prefs;
	char	userhash[16];
};




