//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "StdAfx.h"
#include "preferences.h"
#include <time.h>
#include "opcodes.h"

CPreferences::CPreferences(){
	srand((uint32)time(0)); // we need random numbers sometimes

	prefs = new Preferences_Struct;
	memset(prefs,0,sizeof(Preferences_Struct));
	//get application start directory
	char buffer[490];
	::GetModuleFileName(0, buffer, 490);
	LPTSTR pszFileName = _tcsrchr(buffer, '\\') + 1;
	*pszFileName = '\0';
	appdir = strdup(buffer);
	CreateUserHash();
	// load preferences.dat or set standart values
	char* fullpath = new char[strlen(appdir)+16];
	sprintf(fullpath,"%spreferences.dat",appdir);
	FILE* preffile = fopen(fullpath,"rb");
	delete[] fullpath;
	if (!preffile){
		SetStandartValues();
	}
	else{
		fread(prefs,sizeof(Preferences_Struct),1,preffile);
		if (ferror(preffile))
			SetStandartValues();
		switch(prefs->version){
			case PREFFILE_VERSION:
				break;
			case 1:/*version 1*/
				prefs->ICH = true;
				prefs->autoserverlist = false;
				prefs->updatenotify = true;
			case 2:/*version 2*/
				prefs->mintotray = true;
				CreateUserHash();
				memcpy(&prefs->userhash,&userhash,16);
			case 3:
				prefs->autoconnect = 0;

				Save();
				break;
			default:
				SetStandartValues();
		}
		fclose(preffile);
	}

	// shared directories
	fullpath = new char[strlen(appdir)+14];
	sprintf(fullpath,"%sshareddir.dat",appdir);
	CStdioFile* sdirfile = new CStdioFile();
	if (sdirfile->Open(fullpath,CFile::modeRead)){
		CString toadd;
		while (sdirfile->ReadString(toadd))
			shareddir_list.AddHead(toadd);
		sdirfile->Close();
	}
	delete sdirfile;
	delete[] fullpath;
	//serverlist adresses
	fullpath = new char[strlen(appdir)+20];
	sprintf(fullpath,"%sadresses.dat",appdir);
	sdirfile = new CStdioFile();
	if (sdirfile->Open(fullpath,CFile::modeRead)){
		CString toadd;
		while (sdirfile->ReadString(toadd))
			adresses_list.AddHead(toadd);
		sdirfile->Close();
	}
	delete sdirfile;
	delete[] fullpath;	

	userhash[5] = 14;
	userhash[14] = 111;

	::CreateDirectory(GetIncomingDir(),0);
	::CreateDirectory(GetTempDir(),0);

	// check registry if ed2k links is assigned to emule
	CRegKey regkey;
	regkey.Create(HKEY_CLASSES_ROOT,"ed2k\\shell\\open\\command");
	ULONG maxsize = 500;
	TCHAR rbuffer[500];
	char modbuffer[490];
	char regbuffer[520];
	regkey.QueryStringValue(0,rbuffer,&maxsize);
	::GetModuleFileName(0,modbuffer, 490);
	sprintf(regbuffer,"\"%s\" \"%%1\"",modbuffer);
	if (strcmp(rbuffer,regbuffer)){
		if (MessageBox(0,"eMule is not assigned to ED2K links. Do you want to assign eMule to ED2K links now (recommended) ?","ED2K Links",MB_ICONQUESTION|MB_YESNO) == IDYES)
			regkey.SetStringValue(0,regbuffer);
	}
	regkey.Close();
}
void CPreferences::SetStandartValues(){
	prefs->version = PREFFILE_VERSION;
	prefs->maxupload = UNLIMITED;
	prefs->maxdownload = UNLIMITED;
	uint16 randnumber = (uint16)rand();
	sprintf(prefs->nick,"http://emule.sf.net");
	sprintf(prefs->incomingdir,"%sIncoming",appdir);
	sprintf(prefs->tempdir,"%sTemp",appdir);
	prefs->reconnect = true;
	prefs->scorsystem = true;
	prefs->maxconnections = 500;
	prefs->deadserver = 1;
	prefs->port = 4662;
	CreateUserHash();
	memcpy(&prefs->userhash,&userhash,16);
	prefs->ICH = true;
	prefs->autoserverlist = false;
	prefs->updatenotify = true;
	prefs->mintotray = true;
	Save();
}

uint16 CPreferences::GetMaxDownload(){
	//dont be a Lam3r :)
	return ((GetMaxUpload() < 10)? GetMaxUpload()*3 : prefs->maxdownload);
}

bool CPreferences::Save(){
	bool error = false;
	char* fullpath = new char[strlen(appdir)+16];
	sprintf(fullpath,"%spreferences.dat",appdir);
	FILE* preffile = fopen(fullpath,"wb");
	prefs->version = PREFFILE_VERSION;
	delete[] fullpath;
	if (preffile){
		error = fwrite(prefs,sizeof(Preferences_Struct),1,preffile);
		fclose(preffile);
	}
	else
		error = true;
	fullpath = new char[strlen(appdir)+14];
	sprintf(fullpath,"%sshareddir.dat",appdir);
	CStdioFile* sdirfile = new CStdioFile();
	if (sdirfile->Open(fullpath,CFile::modeCreate|CFile::modeWrite)){

		for (POSITION pos = shareddir_list.GetHeadPosition();pos != 0;shareddir_list.GetNext(pos)){
			sdirfile->WriteString(shareddir_list.GetAt(pos).GetBuffer());
			sdirfile->Write("\n",1);
		}
		sdirfile->Close();
	}
	else
		error = true;
	delete[] fullpath;
	::CreateDirectory(GetIncomingDir(),0);
	::CreateDirectory(GetTempDir(),0);	
	return error;
}

void CPreferences::CreateUserHash(){
	for (int i = 0;i != 8; i++){ 
		uint16	random = rand();
		memcpy(&userhash[i*2],&random,2);
	}
	// mark as emule client. that will be need in later version
	userhash[5] = 14;
	userhash[14] = 111;
}

CPreferences::~CPreferences(){
	delete[] appdir;
	delete prefs;
}
