//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "knownfile.h"
#include "types.h"
#include "opcodes.h"

#define	PS_READY			0
#define	PS_EMPTY			1
#define PS_WAITINGFORHASH	2
#define PS_HASHING			3
#define PS_ERROR			4
#define	PS_UNKNOWN			6
#define PS_PAUSED			7
#define PS_COMPLETING		8
#define PS_COMPLETE			9

#define PR_VERYLOW			-1
#define PR_LOW				0 //*
#define PR_NORMAL			1 // Don't change - needed for edonkey clients
#define	PR_HIGH				2 //*
#define PR_VERYHIGH			3

class CSearchFile;
class CUpDownClient;

class CPartFile : public CKnownFile {
public:
	CPartFile();
	CPartFile(CSearchFile* searchresult);  //used when downloading a new file
	CPartFile(CString edonkeylink);
	virtual ~CPartFile();
	
	bool	CreateFromFile(char* directory,char* filename)	{return false;}// not supported in this class
	bool	LoadFromFile(FILE* file)						{return false;}
	bool	WriteToFile(FILE* file)							{return false;}
	bool	IsPartFile()									{return !(status == PS_COMPLETE);}
	uint32	Process(sint16 reducedownload);
	bool	LoadPartFile(char* in_directory, char* filename); //filename = *.part.met
	bool	SavePartFile();
	void	PartFileHashFinished(CKnownFile* result);
	bool	HashSinglePart(uint16 partnumber); // true = ok , false = corrupted	

	void	AddGap(uint32 start, uint32 end);
	void	FillGap(uint32 start, uint32 end);
	void	DrawStatusBar(CDC* dc,RECT* rect);
	bool	IsComplete(uint32 start, uint32 end);
	bool	IsPureGap(uint32 start, uint32 end);
	bool	IsCorruptedPart(uint16 partnumber);

	bool	GetNextRequestedBlock(CUpDownClient* sender,Requested_Block_Struct** newblocks,uint16* count);
	void	WritePartStatus(CFile* file);
	void	AddSources(CMemFile* sources,uint32 serverip, uint16 serverport);
	uint8	GetStatus();
	void	NewSrcPartsInfo();
	void	SetPriority(uint8 np);
	char*	GetPartMetFileName()							{return partmetfilename;}
	uint32	GetTransfered()									{return transfered;}
	uint8	GetPriority()									{return priority;}
	char*	GetFullName()									{return fullname;}
	uint16	GetSourceCount()								{return srclist.GetCount();}
	uint16	GetTransferingSrcCount()						{return transferingsrc;}
	uint32	GetDatarate()									{return datarate;}
	uint8	GetPercentCompleted()							{return percentcompleted;}
	bool	IsMovie();
	
	void	BlockReceived(uint32 start,uint32 end, char* blockdata, uint32 transferedsize = 0);
	void	RemoveBlockFromList(uint32 start,uint32 end);
	void	RemoveAllSources();
	void	DeleteFile();
	void	StopFile();
	void	PauseFile();
	void	ResumeFile();
protected:
	bool	GetNextEmptyBlockInPart(uint16 partnumber,Requested_Block_Struct* result);
	bool	IsAlreadyRequested(uint32 start, uint32 end);
	void	CompleteFile(bool hashingdone);
	void	CreatePartFile();
	void	Init();
private:
	uint16	count;
	uint16	transferingsrc;
	uint32	datarate;
	char*	fullname;
	char*	partmetfilename;
	uint32	transfered;
	bool	paused;
	uint8	priority;
	uint8	status;
	bool	newdate;	// indicates if there was a writeaccess to the .part file
	uint32	lastsearchtime;
	CTypedPtrList<CPtrList, Gap_Struct*> gaplist;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> requestedblocks_list;
	uint16*	srcpartfrequency;
	uint8	percentcompleted;
	CList<uint16,uint16>	corrupted_list;
public:
	CTypedPtrList<CPtrList, CUpDownClient*> srclist;
	bool	srcarevisible; // used for downloadlistctrl
	bool	hashsetneeded;							
};
