//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// handling incoming connections (up or downloadrequests)

#pragma once
#include "preferences.h"
#include "packets.h"


class CUpDownClient;
class CPacket;
class CTimerWnd;

class CClientReqSocket : public CAsyncSocket{
	friend class CListenSocket;
public:
	CClientReqSocket(CPreferences* in_prefs,bool connected, CUpDownClient* in_client = 0);
	~CClientReqSocket();
	void		 Disconnect();
	bool	SendPacket(Packet* packet, bool delpacket = true,bool controlpacket = true);// controlpackets have a higher priority
	bool	IsBusy()	{return isbusy;}
	bool	IsConnected()	{return connected;}
	bool	IsDisconnected(){return disconnected;}
	void	ResetTimeOutTimer();
	bool	CheckTimeOut();
	virtual int	 Send(const void*lpBuf,int nBufLen,int nFlags = 0);
	void	SetDownloadLimit(uint32 limit);
	void	DisableDownloadLimit()		{limitenabled = false;OnReceive(0);}

protected:
	virtual void OnClose(int nErrorCode);
	virtual void OnReceive(int nErrorCode);
	virtual	void OnConnect(int nErrorCode);
	virtual void OnSend(int nErrorCode);

private:
	uint32	downloadlimit;
	bool	limitenabled;
	bool	ProcessPacket(char* packet, uint32 size,uint8 opcode);
	bool	ProcessExtPacket(char* packet, uint32 size,uint8 opcode);
	bool	headercomplete;
	bool	isbusy;
	int32	sizetoget;
	int32	sizereceived;
	char*	rbuffer;
	uint8	cur_prot;
	CUpDownClient*	client;
	CPreferences* app_prefs;
	char*	pendingbuffer;
	uint32	pendingblen;
	bool	connected;
	bool	disconnected;
	uint32	timeout_timer;
	bool	dontnotify;
	CTypedPtrList<CPtrList, Packet*> controlpacket_queue;
	CTypedPtrList<CPtrList, Packet*> standartpacket_queue;
	
};
// CListenSocket command target
class CListenSocket : public CAsyncSocket{
public:
	CListenSocket(CPreferences* in_prefs);
	~CListenSocket();
	bool	StartListening();
	virtual void OnAccept(int nErrorCode);
	void	Process();
	void	RemoveSocket(CClientReqSocket* todel);
	void	AddSocket(CClientReqSocket* toadd);
	uint16	GetOpenSockets()		{return opensockets;}
	void	KillAllSockets();
	bool	TooManySockets();
private:
	CPreferences* app_prefs;
	CTypedPtrList<CPtrList, CClientReqSocket*> socket_list;
	uint16 opensockets;
};

