//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// ListenSocket.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "ListenSocket.h"
#include "opcodes.h"
#include "KnownFile.h"
#include "sharedfilelist.h"
#include "uploadqueue.h"
#include "updownclient.h"
#include "clientlist.h"


// CClientReqSocket
CClientReqSocket::CClientReqSocket(CPreferences* in_prefs,bool in_connected, CUpDownClient* in_client){
	app_prefs = in_prefs;
	sizereceived = 0;
	sizetoget = 0;
	rbuffer = 0;
	cur_prot = 0;
	headercomplete = false;
	isbusy = false;
	client = in_client;
	connected = in_connected;
	disconnected = false;
	theApp.listensocket->AddSocket(this);
	ResetTimeOutTimer();
	limitenabled = false;
	downloadlimit = 0;
	dontnotify = false;
	if (in_connected){
		uint8 tv = 1;
		SetSockOpt(SO_DONTLINGER,&tv,sizeof(BOOL));
	}
}


CClientReqSocket::~CClientReqSocket(){
	if (client)
		client->socket = 0;
	client = 0;
	for (POSITION pos = controlpacket_queue.GetHeadPosition();pos != 0;controlpacket_queue.GetNext(pos))
		delete controlpacket_queue.GetAt(pos);
	controlpacket_queue.RemoveAll();
	for (POSITION pos = standartpacket_queue.GetHeadPosition();pos != 0;standartpacket_queue.GetNext(pos))
		delete standartpacket_queue.GetAt(pos);
	standartpacket_queue.RemoveAll();
	theApp.listensocket->RemoveSocket(this);
	if (rbuffer)
		delete[] rbuffer;
	dontnotify = true;
	ShutDown(2);
	Close();
}

void CClientReqSocket::ResetTimeOutTimer(){
	timeout_timer = ::GetTickCount();
};

bool CClientReqSocket::CheckTimeOut(){
	if (::GetTickCount() - timeout_timer > CONNECTION_TIMEOUT){
		timeout_timer = ::GetTickCount();
		Disconnect();
		return true;
	}
	return false;
};

void CClientReqSocket::SetDownloadLimit(uint32 limit){
	limitenabled = true;
	downloadlimit = limit;
	OnReceive(0);
}

void CClientReqSocket::OnClose(int nErrorCode){
	CAsyncSocket::OnClose(nErrorCode);
	for (POSITION pos = controlpacket_queue.GetHeadPosition();pos != 0;controlpacket_queue.GetNext(pos))
		delete controlpacket_queue.GetAt(pos);
	controlpacket_queue.RemoveAll();
	for (POSITION pos = standartpacket_queue.GetHeadPosition();pos != 0;standartpacket_queue.GetNext(pos))
		delete standartpacket_queue.GetAt(pos);
	standartpacket_queue.RemoveAll();
	if (dontnotify)
		return;
	Disconnect();
};

void CClientReqSocket::Disconnect(){
	connected = false;
	disconnected = true;
	dontnotify = true;
	Close();
	if (!client)
		delete this;
	else
		client->Disconnected();
};

void CClientReqSocket::OnReceive(int nErrorCode){
	// TC
	try{
		ResetTimeOutTimer();
		if  (!sizetoget || !headercomplete){
			if (!sizetoget){
				if (rbuffer)
					delete[] rbuffer;
				rbuffer = new char[5];
				headercomplete = false;
				uint32 read = this->Receive(rbuffer,5);
				if (read == (uint32)SOCKET_ERROR)
					return;
				sizereceived +=read; 
			}
			else{
				uint32 read = Receive(rbuffer+sizereceived,sizetoget-sizereceived);
				if (read == (uint32)SOCKET_ERROR)
					return;
				sizereceived +=read; 
			}

			if (sizereceived < 5){
				sizetoget = 5;
				return;
			}
			else{
				Header_Struct* header = (Header_Struct*) rbuffer;
				switch (header->eDonkeyID){
					case OP_EDONKEYPROT:
					case OP_EXTENDEDPROT:
					case OP_EMULEPROT:
						cur_prot = header->eDonkeyID;
						break;
					case OP_MLDONKEYPROT:
					default:	
						delete[] rbuffer;
						rbuffer = 0;
						sizereceived = 0;
						throw "Error in Client:OnReceive! header invalid";
				}
				headercomplete = true;
				sizetoget = header->packetlength;
				sizereceived = 0;
				delete[] rbuffer;
				rbuffer = 0;
				return;
			}
		}
		else {
			if (!rbuffer || !sizereceived){
				if (rbuffer)
					delete[] rbuffer;
				rbuffer = new char[sizetoget];
			}
			uint32 toreceive = sizetoget-sizereceived;
			if (limitenabled && (toreceive > downloadlimit))
				toreceive = downloadlimit;
			uint32 read= 0;
			if (toreceive)
				read  = Receive(rbuffer+sizereceived,toreceive);
			if (read == (uint32)SOCKET_ERROR)
				return;
			if (limitenabled)
				 downloadlimit -= read;
			sizereceived += read;
			if (sizetoget == sizereceived){
				if (cur_prot == OP_EDONKEYPROT){
					if (!ProcessPacket(rbuffer+1, sizetoget-1, rbuffer[0]))
						return;
				}
				else{
					if (!ProcessExtPacket(rbuffer+1, sizetoget-1, rbuffer[0]))
						return;
				}
				delete[] rbuffer;
				rbuffer = 0;
				sizetoget = 0;
				sizereceived = 0;
			}
		}
	}
	catch(...){
		/*if (client)
			theApp.emuledlg->AddLogLine(false,"Client '%s' (IP: %s) caused an unhandled error while receiving or processing a packet. Disconnecting"
			,client->GetUserName(),client->GetFullIP());
		else*/
			theApp.emuledlg->AddLogLine(false,"A client caused an unhandled error while receiving or processing a packet. Disconnecting");
		if (client)
			client->SetDownloadState(DS_ERROR);
		ShutDown(2);
		Close();
		return;
	}
}

bool CClientReqSocket::ProcessPacket(char* packet, uint32 size, uint8 opcode){
	try{
		if (!client && opcode != OP_HELLO)
			throw "Asks for something without saying hello";
		switch(opcode){
			case OP_HELLOANSWER:{
				client->ProcessHelloAnswer(packet,size);
				client->ConnectionEstablished();

				break;
			}
			case OP_HELLO:{
				if (!client){
					// create new client to save standart informations
					client = new CUpDownClient(this);
				}
				client->ProcessHelloPacket(packet,size);
				// now we check if we now this client already. if yes this socket will
				// be attached to the known client, the new client will be deleted
				// and the var. "client" will point to the known client.
				// if not we keep our new-constructed client ;)
				if (theApp.clientlist->AttachToAlreadyKnown(&client,this)){
					// update the old client informations
					client->ProcessHelloPacket(packet,size);
				}
				else
					theApp.clientlist->AddClient(client);
				// send a response packet with standart informations
				if (client->GetClientSoft() == SO_EMULE)
					client->SendMuleInfoPacket(false);
				client->SendHelloAnswer();
				client->ConnectionEstablished();

				break;
			}
			case OP_FILEREQUEST:{
				if (size == 16){
					if (!client->GetWaitStartTime())
						client->SetWaitStartTime();
					client->SetUploadState(US_PENDING);
					CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)packet);
					if (!reqfile)
						break;
					// if wer are downloading this file, this could be a new source
					if (reqfile->IsPartFile())
						theApp.downloadqueue->CheckAndAddKnownSource((CPartFile*)reqfile,client);
					// send filename etc
					memcpy(client->reqfileid,packet,16);
					CMemFile* data = new CMemFile();
					data->Write(reqfile->GetFileHash(),16);
					uint16 namelength = strlen(reqfile->GetFileName());
					data->Write(&namelength,2);
					data->Write(reqfile->GetFileName(),namelength);
					Packet* packet = new Packet(data);
					packet->opcode = OP_FILEREQANSWER;
					delete data;
					SendPacket(packet,true);
					//send filestatus
					data = new CMemFile();
					data->Write(reqfile->GetFileHash(),16);
					if (reqfile->IsPartFile())
						((CPartFile*)reqfile)->WritePartStatus(data);
					else{
						uint32 null = 0;
						data->Write(&null,3);
					}
					packet = new Packet(data);
					packet->opcode = OP_FILESTATUS;
					delete data;
					SendPacket(packet,true);
					break;
				}
				throw "invalid OP_FILEREQUEST packet size";
				break;
			}
			case OP_FILEREQANSWER:{
				client->ProcessFileInfo(packet,size);
				break;
			}
			case OP_FILESTATUS:{
				client->ProcessFileStatus(packet,size);
				break;
			}
			case OP_STARTUPLOADREQ:{
				char* name = client->GetUserName();
				theApp.uploadqueue->AddClientToQueue(client);
				break;
			}
			case OP_ACCEPTUPLOADREQ:{
				if (client->GetDownloadState() == DS_ONQUEUE ){
					client->SetDownloadState(DS_DOWNLOADING);
					client->SendBlockRequests();
				}
				break;
			}
			case OP_REQUESTPARTS:{
				CMemFile* data = new CMemFile((BYTE*)packet,size);
				uchar reqfilehash[16];
				data->Read(reqfilehash,16);
				Requested_Block_Struct* reqblock1 = new Requested_Block_Struct;
				Requested_Block_Struct* reqblock2 = new Requested_Block_Struct;
				Requested_Block_Struct* reqblock3 = new Requested_Block_Struct;
				data->Read(&reqblock1->StartOffset,4);
				data->Read(&reqblock2->StartOffset,4);
				data->Read(&reqblock3->StartOffset,4);
				data->Read(&reqblock1->EndOffset,4);
				data->Read(&reqblock2->EndOffset,4);
				data->Read(&reqblock3->EndOffset,4);
				memcpy(&reqblock1->FileID,reqfilehash,16);
				memcpy(&reqblock2->FileID,reqfilehash,16);
				memcpy(&reqblock3->FileID,reqfilehash,16);
				if (reqblock1->EndOffset-reqblock1->StartOffset == 0)			
					delete reqblock1;
				else
					client->AddReqBlock(reqblock1);

				if (reqblock2->EndOffset-reqblock2->StartOffset == 0)			
					delete reqblock2;
				else
					client->AddReqBlock(reqblock2);

				if (reqblock3->EndOffset-reqblock3->StartOffset == 0)			
					delete reqblock3;
				else
					client->AddReqBlock(reqblock3);
				delete data;
				break;
			}
			case OP_CANCELTRANSFER:{
				theApp.uploadqueue->RemoveFromUploadQueue(client);
				break;
			}
			case OP_HASHSETREQUEST:{
				if (size != 16)
					throw "invalid OP_HASHSETREQUEST packet size";
				client->SendHashsetPacket(packet);
				break;
			}
			case OP_HASHSETANSWER:{
				client->ProcessHashSet(packet,size);
				break;
			}
			case OP_SENDINGPART:{
				client->ProcessBlockPacket(packet,size);
				break;
			}
			case OP_OUTOFPARTREQS:{
				break;
			}
			case OP_MESSAGE:{
				uint16 length;
				memcpy(&length,packet,2);
				if (length+2 != size)
					throw "invalid message packet";
				char* message = new char[length+1];
				memcpy(message,packet+2,length);
				message[length] = 0;
				theApp.emuledlg->chatwnd.chatselector.ProcessMessage(client,message);
				delete[] message;
				break;
			}
			default:
				;//theApp.emuledlg->AddLogLine(false,"unknown opcode: %i %h",opcode,opcode);
			  
		}
	}
	catch(char* error){
		delete[] rbuffer;
		rbuffer = 0;
		sizetoget = 0;
		sizereceived = 0;
		if (client)
			//TODO write this into a debugfile

			//theApp.emuledlg->AddLogLine(false,
			//"Client '%s' (IP:%s) caused an error: %s. Disconnecting client!"
			//,client->GetUserName(),client->GetFullIP(),error);
			;
		else
			theApp.emuledlg->AddLogLine(false,"A client caused an error or did something bad: %s. Disconnecting client!",error);
		client->SetDownloadState(DS_ERROR);		
		Close();
		return false;
	}
	return true;
}

bool CClientReqSocket::ProcessExtPacket(char* packet, uint32 size, uint8 opcode){
	try{
		if (!client)
			throw "Unknown clients sends extended protocol packet";
		switch(opcode){
			case OP_EMULEINFO:{
				client->ProcessMuleInfoPacket(packet,size);
				client->SendMuleInfoPacket(true);
				break;
			}
			case OP_EMULEINFOANSWER:{
				client->ProcessMuleInfoPacket(packet,size);
				break;
			}
			case OP_COMPRESSEDPART:{
				client->ProcessBlockPacket(packet,size,true);
				break;
			}
			case OP_QUEUERANKING:{
				if (size != 12)
					throw "invalid size (OP_QUEUERANKING)";
				uint16 newrank;
				memcpy(&newrank,packet+0,2);
				client->SetRemoteQueueRank(newrank);

			}

			default:
				;//theApp.emuledlg->AddLogLine(false,"unknown opcode: %i %h",opcode,opcode);
			  
		}
	}
	catch(char* error){
		delete[] rbuffer;
		rbuffer = 0;
		sizetoget = 0;
		sizereceived = 0;
		theApp.emuledlg->AddLogLine(false,"A client caused an error or did something bad: %s. Disconnecting client!",error);
		client->SetDownloadState(DS_ERROR);		
		Close();
		return false;
	}
	return true;
}

bool CClientReqSocket::SendPacket(Packet* packet, bool delpacket,bool controlpacket){
	try{
		while (true){
			if ( (!IsConnected()) || IsBusy() ){
				if (!delpacket){
						Packet* copy = new Packet(packet->opcode,packet->size);
						memcpy(copy->pBuffer,packet->pBuffer,packet->size);
						packet = copy;
					}				
				if (controlpacket){
					controlpacket_queue.AddTail(packet);
					return true;
				}
				else{
					standartpacket_queue.AddTail(packet);
					return true;
				}
			}
			if (Send(packet->GetPacket(),packet->GetRealPacketSize()))
				continue;	// if an error occurs save the packet
			break; // no errors, so we can go on
		}
		if (delpacket)
			delete packet;
		return true;
	}
	catch(...){
		if (client)
			theApp.emuledlg->AddLogLine(false,"Client '%s' (IP: %s) caused an unhandled socketerror while sending a packet. Disconnecting",client->GetUserName(),client->GetFullIP());
		else
			theApp.emuledlg->AddLogLine(false,"A client caused an unhandled socketerror while sending a packet. Disconnecting");
		Close();
		return false;
	}
}

void CClientReqSocket::OnConnect(int nErrorCode){
	CAsyncSocket::OnConnect(nErrorCode);
	ResetTimeOutTimer();
	if (nErrorCode){
		if (client)
			client->ConnectionFailed();
	}
	else{
		uint8 tv = 1;
		SetSockOpt(SO_DONTLINGER,&tv,sizeof(BOOL));
		connected = true;
		dontnotify = false;
	}
}

void CClientReqSocket::OnSend(int nErrorCode){
	isbusy = false;
	while (controlpacket_queue.GetHeadPosition() != 0 && (!IsBusy()) && IsConnected()){
		Packet* cur_packet = controlpacket_queue.GetHead();
		if (!Send(cur_packet->GetPacket(),cur_packet->GetRealPacketSize())){
			controlpacket_queue.RemoveHead();
			delete cur_packet;
		}
		else
			return;
	}

	while (standartpacket_queue.GetHeadPosition() != 0 && (!IsBusy()) && IsConnected()){
		Packet* cur_packet = standartpacket_queue.GetHead();
		if (!Send(cur_packet->GetPacket(),cur_packet->GetRealPacketSize())){
			standartpacket_queue.RemoveHead();
			delete cur_packet;
		}
		else
			return;
	}

}

int CClientReqSocket::Send(const void*lpBuf,int nBufLen,int nFlags){
	ResetTimeOutTimer();
	if (CAsyncSocket::Send(lpBuf,nBufLen,nFlags) == SOCKET_ERROR){
		if (GetLastError() == WSAEWOULDBLOCK){
			isbusy = true;
			return -1;
		}
		else{
			connected = false;
			disconnected = true;
			return -1;
		}
	}
	return 0;
	
}
// CListenSocket
// CListenSocket member functions
CListenSocket::CListenSocket(CPreferences* in_prefs){
	app_prefs = in_prefs;
	opensockets = 0;
}

CListenSocket::~CListenSocket(){
	Close();
	KillAllSockets();
}

bool CListenSocket::StartListening(){
	return (this->Create(app_prefs->GetPort()) && this->Listen());
}

void CListenSocket::OnAccept(int nErrorCode){
	//TODO: Block banned IPs here
	CClientReqSocket* newclient = new CClientReqSocket(app_prefs,true);
	this->Accept(*newclient);
}

void CListenSocket::Process(){
	POSITION pos2;
	opensockets = 0;
	for(POSITION pos1 = socket_list.GetHeadPosition(); ( pos2 = pos1 ) != NULL; ){
       socket_list.GetNext(pos1);
	   if ( socket_list.GetAt(pos2)->IsConnected() )
		   opensockets++;
       socket_list.GetAt( pos2 )->CheckTimeOut();
   }
}

void CListenSocket::AddSocket(CClientReqSocket* toadd){
	socket_list.AddTail(toadd);
}

void CListenSocket::RemoveSocket(CClientReqSocket* todel){
	POSITION pos2,pos1;
	for(pos1 = socket_list.GetHeadPosition(); ( pos2 = pos1 ) != NULL; ){
       socket_list.GetNext(pos1);
	   if ( socket_list.GetAt(pos2) == todel )
			socket_list.RemoveAt(pos2);
   }
}

void CListenSocket::KillAllSockets(){
	for (POSITION pos = socket_list.GetHeadPosition();pos != 0;pos = socket_list.GetHeadPosition()){
		CClientReqSocket* cur_socket = socket_list.GetAt(pos);
			if (cur_socket->client)
				delete cur_socket->client;
			else
				delete cur_socket;
	}
}

bool CListenSocket::TooManySockets(){
	if (GetOpenSockets() > app_prefs->GetMaxConnections()){
		return true;
	}
	else
		return false;
}
