//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "StdAfx.h"
#include "knownfilelist.h"
#include "opcodes.h"
#include "emule.h"

CKnownFileList::CKnownFileList(char* in_appdir){
	appdir = in_appdir;
	Init();
}

CKnownFileList::~CKnownFileList(){
	Clear();
}

bool CKnownFileList::Init(){
	CKnownFile* Record = 0; 
	FILE* file = 0; 
	try {
		char* fullpath = new char[strlen(appdir)+10];
		strcpy(fullpath,appdir);
		strcat(fullpath,"known.met");
		if (!(file = fopen(fullpath, "rb"))){
			delete[] fullpath;	
			return false;
		}
		delete[] fullpath;

		if (fgetc(file) != MET_HEADER){
			return false;
		}
		CSingleLock sLock(&list_mut,true); // to make sure that its thread-safe
		uint32 RecordsNumber;
		fread(&RecordsNumber,4,1,file);
		for (uint32 i = 0; i < RecordsNumber; i++) {
			Record =  new CKnownFile();
			Record->LoadFromFile(file);
			Add(Record);
		}
		sLock.Unlock();
		return (fclose(file));
	}
	catch (...) {
		//clear
		safe_delete(Record);
		if (file)
			fclose(file);
		return false;
	}
}

void CKnownFileList::Save(){
	FILE* file = 0;
	char* fullpath = new char[strlen(appdir)+10];
	strcpy(fullpath,appdir);
	strcat(fullpath,"known.met");
	if (!(file = fopen(fullpath, "wb"))){
		delete[] fullpath;	
		return;
	}
	delete[] fullpath;
	fputc(MET_HEADER,file);
	uint32 RecordsNumber = GetCount();
	fwrite(&RecordsNumber,4,1,file);
	for (uint32 i = 0; i < RecordsNumber; i++) {
		ElementAt(i)->WriteToFile(file);
	}
	fclose(file);
}

void CKnownFileList::Clear(){
	for (int i = 0; i != GetSize();i++)
		safe_delete(this->ElementAt(i));
	RemoveAll();
	SetSize(0);
}

CKnownFile* CKnownFileList::FindKnownFile(char* filename,uint32 in_date,uint32 in_size){
	for (int i = 0;i != this->GetCount();i++){
		if (ElementAt(i)->GetFileDate() == in_date && ElementAt(i)->GetFileSize() == in_size && (!strcmp(filename,ElementAt(i)->GetFileName())))
			return ElementAt(i);
	}
	return 0;
}

void CKnownFileList::SafeAddKFile(CKnownFile* toadd){
	CSingleLock sLock(&list_mut,true);
	Add(toadd);
	sLock.Unlock();
}

