// parts of this file are based on work from pan One (http://home-3.tiscali.nl/~meost/pms/)

//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "StdAfx.h"
#include "knownfile.h"
#include "opcodes.h"
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>




CKnownFile::CKnownFile(){
	filetype = 2;
	directory = 0;
	filename = 0;
	filesize = 0;
	date = 0;
}

CKnownFile::~CKnownFile(){
	for (int i = 0; i != hashlist.GetSize(); i++)
		if (hashlist[i])
			delete[] hashlist[i];
	for (int i = 0; i != taglist.GetSize(); i++)
		safe_delete(taglist[i]);
	if (filename)
		delete[] filename;
	if (directory)
		delete[] directory;
}

void CKnownFile::SetPath(char* path){
	if (directory)
		delete[] directory;
	directory = strdup(path);
}

bool CKnownFile::CreateFromFile(char* in_directory,char* in_filename){
	// TODO Errorhandling
	//first create the filehashset
	// open file
	directory = strdup(in_directory);
	char* namebuffer = new char[strlen(in_directory)+strlen(in_filename)+2];
	sprintf(namebuffer,"%s\\%s",in_directory,in_filename);
	FILE* file = fopen(namebuffer,"rbS");
	if (!file)
		return false;
	delete namebuffer;
	// set filesize + name
	filename = strdup(in_filename);
	filesize =_filelength(file->_file);
	// create hashset
	uint32 togo = filesize;
	for (uint16 hashcount = 0;togo >= PARTSIZE;) {
		uchar* newhash = new uchar[16];
		CreateHashFromFile(file,PARTSIZE,newhash);
		hashlist.Add(newhash);
		togo -= PARTSIZE;
		hashcount++;
	}
	uchar* lasthash = new uchar[16];
	memset(lasthash,0,16);
	CreateHashFromFile(file,togo,lasthash);
	if (!hashcount)
		memcpy(filehash,lasthash,16);
	else {
		hashlist.Add(lasthash);
		uchar* buffer = new uchar[hashlist.GetCount()*16];
		for (int i = 0;i != hashlist.GetCount();i++)
			memcpy(buffer+(i*16),hashlist[i],16);
		CreateHashFromString(buffer,hashlist.GetCount()*16,filehash);
	}
	// TODO: Add filetags

	// set lastwrite date
	struct _stat fileinfo;
	_fstat(file->_file,&fileinfo);
	date = fileinfo.st_mtime;
	//finished
	fclose(file);
	return true;	
}

bool CKnownFile::LoadHashsetFromFile(FILE* file){
	fread(&filehash,16,1,file);
	uint16	parts;
	fread(&parts,2,1,file);
	for (int i = 0; i != parts; i++){
		uchar* cur_hash = new uchar[16];
		fread(cur_hash,16,1,file);
		hashlist.Add(cur_hash);
	}
	return !ferror(file);
}

// needed for memfiles. its probably better to switch everything to CFile...
bool CKnownFile::LoadHashsetFromFile(CFile* file){
	uchar checkid[16];
	file->Read(&checkid,16);
	uint16	parts;
	file->Read(&parts,2);
	for (int i = 0; i != parts; i++){
		uchar* cur_hash = new uchar[16];
		file->Read(cur_hash,16);
		hashlist.Add(cur_hash);
	}
	// trust noone ;-)

	if (!hashlist.IsEmpty()){
		uchar* buffer = new uchar[hashlist.GetCount()*16];
		for (int i = 0;i != hashlist.GetCount();i++)
			memcpy(buffer+(i*16),hashlist[i],16);
		CreateHashFromString(buffer,hashlist.GetCount()*16,checkid);
	}
	if (!memcmp(filehash,checkid,16))
		return true;
	else{
		for (int i = 0; i != hashlist.GetSize(); i++)
			delete[] hashlist[i];
		hashlist.RemoveAll();
		return false;
	}
}

bool CKnownFile::LoadTagsFromFile(FILE* file){
	uint32 tagcount;
	fread(&tagcount,4,1,file);
	for (uint32 j = 0; j != tagcount;j++){
		CTag* newtag = new CTag(file);
		switch(newtag->tag->specialtag){
			case FT_FILENAME:{
				filename = strdup(newtag->tag->stringvalue);
				delete newtag;
				break;
			}
			case FT_FILESIZE:{
				filesize = newtag->tag->intvalue;
				delete newtag;
				break;
			}
			default:
				taglist.Add(newtag);
		}	
	}
	return !ferror(file);
}

bool CKnownFile::LoadDateFromFile(FILE* file){
	fread(&date,4,1,file);
	return !ferror(file);
}

bool CKnownFile::LoadFromFile(FILE* file){
	return (LoadDateFromFile(file) && LoadHashsetFromFile(file) && LoadTagsFromFile(file)); 
}

bool CKnownFile::WriteToFile(FILE* file){
	// date
	fwrite(&date,4,1,file); 
	// hashset
	fwrite(&filehash,16,1,file);
	uint16 parts = hashlist.GetCount();
	fwrite(&parts,2,1,file);
	for (int i = 0; i != parts; i++)
		fwrite(hashlist[i],16,1,file);
	//tags
	uint32 tagcount = taglist.GetCount()+2;
		// standart tags
	fwrite(&tagcount,4,1,file);
	CTag* nametag = new CTag(FT_FILENAME,filename);
	nametag->WriteTagToFile(file);
	delete nametag;
	CTag* sizetag = new CTag(FT_FILESIZE,filesize);
	sizetag->WriteTagToFile(file);
	delete sizetag;
		//other tags
	for (uint32 j = 0; j != tagcount-2;j++)
		taglist[j]->WriteTagToFile(file);
	return ferror(file);
}

void CKnownFile::CreateHashFromInput(FILE* file,CFile* file2, int Length, uchar* Output, uchar* in_string) { 
	// time critial
	bool PaddingStarted = false;
	uint32 Hash[4];
	Hash[0] = 0x67452301;
	Hash[1] = 0xEFCDAB89;
	Hash[2] = 0x98BADCFE;
	Hash[3] = 0x10325476;
	CFile* data = 0;
	if (in_string)
		data = new CMemFile(in_string,Length);
	uint32 Required = Length;
	uchar	X[64];
	while (Required >= 64){
		if (in_string)
			data->Read(&X,64);
		else if (file)
			fread(&X,64,1,file);
		else if (file2)
			file2->Read(&X,64);
		MD4Transform(Hash, (uint32*)X);
		Required -= 64;
	}
	// bytes to read
	Required = Length % 64;
	if (Required != 0){
		if (in_string)
			data->Read(&X,Required);
		else if (file)
			fread(&X,Required,1,file);
		else if (file2)
			file2->Read(&X,Required);
	}
	// in byte scale 512 = 64, 448 = 56
	if (Required >= 56){
		X[Required] = 0x80;
		PaddingStarted = TRUE;
		memset(&X[Required + 1], 0, 63 - Required);
		MD4Transform(Hash, (uint32*)X);
		Required = 0;
	}
	if (!PaddingStarted)
		X[Required++] = 0x80;
	memset(&X[Required], 0, 64 - Required);
	// add size (convert to bits)
	uint32 Length2 = Length >> 29;
	Length <<= 3;
	memcpy(&X[56], &Length, 4);
	memcpy(&X[60], &Length2, 4);
	MD4Transform(Hash, (uint32*)X);
	memcpy(Output, Hash, 16);
	safe_delete(data);
}
uchar* CKnownFile::GetPartHash(uint16 part){
	if (part >= hashlist.GetCount())
		return 0;
	return hashlist[part];
}

uint16 CKnownFile::GetPartCount(){
	return (filesize/PARTSIZE) + ((filesize % PARTSIZE)? 1:0);
}

static void MD4Transform(uint32 Hash[4], uint32 x[16])
{
  uint32 a = Hash[0];
  uint32 b = Hash[1];
  uint32 c = Hash[2];
  uint32 d = Hash[3];

  /* Round 1 */
  MD4_FF(a, b, c, d, x[ 0], S11); // 01
  MD4_FF(d, a, b, c, x[ 1], S12); // 02
  MD4_FF(c, d, a, b, x[ 2], S13); // 03
  MD4_FF(b, c, d, a, x[ 3], S14); // 04
  MD4_FF(a, b, c, d, x[ 4], S11); // 05
  MD4_FF(d, a, b, c, x[ 5], S12); // 06
  MD4_FF(c, d, a, b, x[ 6], S13); // 07
  MD4_FF(b, c, d, a, x[ 7], S14); // 08
  MD4_FF(a, b, c, d, x[ 8], S11); // 09
  MD4_FF(d, a, b, c, x[ 9], S12); // 10
  MD4_FF(c, d, a, b, x[10], S13); // 11
  MD4_FF(b, c, d, a, x[11], S14); // 12
  MD4_FF(a, b, c, d, x[12], S11); // 13
  MD4_FF(d, a, b, c, x[13], S12); // 14
  MD4_FF(c, d, a, b, x[14], S13); // 15
  MD4_FF(b, c, d, a, x[15], S14); // 16

  /* Round 2 */
  MD4_GG(a, b, c, d, x[ 0], S21); // 17
  MD4_GG(d, a, b, c, x[ 4], S22); // 18
  MD4_GG(c, d, a, b, x[ 8], S23); // 19
  MD4_GG(b, c, d, a, x[12], S24); // 20
  MD4_GG(a, b, c, d, x[ 1], S21); // 21
  MD4_GG(d, a, b, c, x[ 5], S22); // 22
  MD4_GG(c, d, a, b, x[ 9], S23); // 23
  MD4_GG(b, c, d, a, x[13], S24); // 24
  MD4_GG(a, b, c, d, x[ 2], S21); // 25
  MD4_GG(d, a, b, c, x[ 6], S22); // 26
  MD4_GG(c, d, a, b, x[10], S23); // 27
  MD4_GG(b, c, d, a, x[14], S24); // 28
  MD4_GG(a, b, c, d, x[ 3], S21); // 29
  MD4_GG(d, a, b, c, x[ 7], S22); // 30
  MD4_GG(c, d, a, b, x[11], S23); // 31
  MD4_GG(b, c, d, a, x[15], S24); // 32

  /* Round 3 */
  MD4_HH(a, b, c, d, x[ 0], S31); // 33
  MD4_HH(d, a, b, c, x[ 8], S32); // 34
  MD4_HH(c, d, a, b, x[ 4], S33); // 35
  MD4_HH(b, c, d, a, x[12], S34); // 36
  MD4_HH(a, b, c, d, x[ 2], S31); // 37
  MD4_HH(d, a, b, c, x[10], S32); // 38
  MD4_HH(c, d, a, b, x[ 6], S33); // 39
  MD4_HH(b, c, d, a, x[14], S34); // 40
  MD4_HH(a, b, c, d, x[ 1], S31); // 41
  MD4_HH(d, a, b, c, x[ 9], S32); // 42
  MD4_HH(c, d, a, b, x[ 5], S33); // 43
  MD4_HH(b, c, d, a, x[13], S34); // 44
  MD4_HH(a, b, c, d, x[ 3], S31); // 45
  MD4_HH(d, a, b, c, x[11], S32); // 46
  MD4_HH(c, d, a, b, x[ 7], S33); // 47
  MD4_HH(b, c, d, a, x[15], S34); // 48

  Hash[0] += a;
  Hash[1] += b;
  Hash[2] += c;
  Hash[3] += d;
}
