//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "StdAfx.h"
#include "partfile.h"
#include "opcodes.h"
#include "types.h"
#include "sharedfilelist.h"
#include "preferences.h"

class CDownloadQueue
{
	friend class CAddFileThread;
public:
	CDownloadQueue(CPreferences* in_prefs,CSharedFileList* in_sharedfilelist);
	~CDownloadQueue();
	void	Process();
	void	Init();
	void	AddSearchToDownload(CSearchFile* toadd);
	void	AddSearchToDownload(CString link);
	bool	IsFileExisting(uchar* fileid);
	bool	IsPartFile(void* totest);
	CPartFile*	GetFileByID(uchar* filehash);
	void    CheckAndAddSource(CPartFile* sender,CUpDownClient* source);
	void    CheckAndAddKnownSource(CPartFile* sender,CUpDownClient* source);
	bool	RemoveSource(CUpDownClient* toremove, bool updatewindow = true);
	void	DeleteAll();
	void	RemoveFile(CPartFile* toremove);
	uint32	GetDatarate()			{return datarate;}
	void	SortByPriority();
protected:
	bool	SendNextUDPPacket();
private:
	CTypedPtrList<CPtrList, CPartFile*> filelist;
	CSharedFileList* sharedfilelist;
	CPreferences*	 app_prefs;
	uint16	filesrdy;
	uint32	datarate;
	CServer*	cur_udpserver;
	CPartFile*	lastfile;
	uint32		lastudpsearchtime;
	uint8		udcounter;
};
