//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "StdAfx.h"
#include "downloadqueue.h"
#include "updownclient.h"
#include "partfile.h"

CDownloadQueue::CDownloadQueue(CPreferences* in_prefs,CSharedFileList* in_sharedfilelist){
	app_prefs = in_prefs;
	sharedfilelist = in_sharedfilelist;
	filesrdy = 0;
	datarate = 0;
	cur_udpserver = 0;
	lastfile = 0;
	lastudpsearchtime = 0;
	udcounter = 0;
}

void CDownloadQueue::Init(){
	// find all part files, read & hash them if needed and store into a list
	CFileFind ff;
	char* searchpath = new char[strlen(app_prefs->GetTempDir())+15];
	sprintf(searchpath,"%s\\*.part.met",app_prefs->GetTempDir());
	bool end = !ff.FindFile(searchpath,0);
	delete[] searchpath;
	if (end){
		theApp.emuledlg->AddLogLine(false,"No part files found");
		return;
	}
	
	uint16 count = 0;
	while (!end){
		end = !ff.FindNextFile();
		if (ff.IsDirectory())
			continue;
		CPartFile* toadd = new CPartFile();
		if (toadd->LoadPartFile(app_prefs->GetTempDir(),ff.GetFileName().GetBuffer())){
			count++;
			filelist.AddTail(toadd);			// to downloadqueue
			if (toadd->GetStatus() == PS_READY)
				sharedfilelist->SafeAddKFile(toadd); // part files are always shared files
			theApp.emuledlg->transferwnd.downloadlistctrl.AddFile(toadd);// show in downloadwindow
		}
		else
			delete toadd;
	}
	ff.Close();
	theApp.emuledlg->AddLogLine(false,"Found %i part files",count);
	SortByPriority();
}

CDownloadQueue::~CDownloadQueue(){
	for (POSITION pos =filelist.GetHeadPosition();pos != 0;filelist.GetNext(pos)){
		filelist.GetAt(pos)->SavePartFile();
		delete filelist.GetAt(pos);
	}
	
}

void CDownloadQueue::AddSearchToDownload(CSearchFile* toadd){
	if (IsFileExisting(toadd->GetFileHash()))
		return;
	CPartFile* newfile = new CPartFile(toadd);
	filelist.AddTail(newfile);
	SortByPriority();
	theApp.emuledlg->transferwnd.downloadlistctrl.AddFile(newfile);
	theApp.emuledlg->AddLogLine(true,"Downloading %s",newfile->GetFileName());
}

void CDownloadQueue::AddSearchToDownload(CString link){
	CPartFile* newfile = new CPartFile(link);
	if (newfile->GetStatus() == PS_ERROR){
		delete newfile;
		return;
	}
	filelist.AddTail(newfile);
	SortByPriority();
	theApp.emuledlg->transferwnd.downloadlistctrl.AddFile(newfile);
	theApp.emuledlg->AddLogLine(true,"Downloading %s",newfile->GetFileName());
}


bool CDownloadQueue::IsFileExisting(uchar* fileid){
	if (CKnownFile* file = sharedfilelist->GetFileByID((uchar*)fileid)){
		if (file->IsPartFile())
			MessageBox(0,"You are already downloading this file",file->GetFileName(),64);
		else
			MessageBox(0,"You already downloaded this file",file->GetFileName(),64);
		return true;
	}
	else if ( file = this->GetFileByID((uchar*)fileid)){
		MessageBox(0,"You are already downloading this file",file->GetFileName(),64);
		return true;
	}
	return false;
}


void CDownloadQueue::Process(){
	sint16 downspeed = 0;
	if (app_prefs->GetMaxDownload() != UNLIMITED && datarate > 1500){
		downspeed =  (uint16)((float)((float)(app_prefs->GetMaxDownload()*1024)/(datarate+1)) * 100);
		if (downspeed < 50)
			downspeed = 50;
		else if (downspeed > 200)
			downspeed = 200;
		//if (app_prefs->GetMaxDownload()*1024 < datarate)
		//	downspeed = 0xFFF;
	}
	datarate = 0;
	for (POSITION pos =filelist.GetHeadPosition();pos != 0;filelist.GetNext(pos)){
		CPartFile* cur_file =  filelist.GetAt(pos);
		if (cur_file->GetStatus() == PS_READY || cur_file->GetStatus() == PS_EMPTY){
			datarate += cur_file->Process(downspeed);
		}
	}
	udcounter++;
	if (udcounter == 10){
		udcounter = 0;
		if ((!lastudpsearchtime) || (::GetTickCount() - lastudpsearchtime) > UDPSERVERREASKTIME)
			SendNextUDPPacket();
	}
}

CPartFile*	CDownloadQueue::GetFileByID(uchar* filehash){
	for (POSITION pos = filelist.GetHeadPosition();pos != 0;filelist.GetNext(pos)){
		if (!memcmp(filehash,filelist.GetAt(pos)->GetFileHash(),16))
			return filelist.GetAt(pos);
	}
	return 0;
}

bool CDownloadQueue::IsPartFile(void* totest){
	for (POSITION pos = filelist.GetHeadPosition();pos != 0;filelist.GetNext(pos))
		if (totest == filelist.GetAt(pos))
			return true;
	return false;
}

void CDownloadQueue::CheckAndAddSource(CPartFile* sender,CUpDownClient* source){
	// uses this only for temp. clients
	for (POSITION pos = filelist.GetHeadPosition();pos != 0;filelist.GetNext(pos)){
		CPartFile* cur_file = filelist.GetAt(pos);
		for (POSITION pos2 = cur_file->srclist.GetHeadPosition();pos2 != 0; cur_file->srclist.GetNext(pos2))
			if (cur_file->srclist.GetAt(pos2)->Compare(source)){
				if (cur_file == sender){ // this file has already this source
					delete source;
					return;
				}
				// set request for this source
				if (cur_file->srclist.GetAt(pos2)->AddRequestForAnotherFile(sender)){
					// add it to uploadlistctrl
					theApp.emuledlg->transferwnd.downloadlistctrl.AddSource(sender,cur_file->srclist.GetAt(pos2),true);
					delete source;
					return;
				}
				else{
					delete source;
					return;
				}
			}
	}
	//our new source is real new but maybe it is already uploading to us?
	//if yes the known client will be attached to the var "source"
	//and the old sourceclient will be deleted
	if (theApp.clientlist->AttachToAlreadyKnown(&source,0))
		source->reqfile = sender;
	else
		theApp.clientlist->AddClient(source);
	sender->srclist.AddTail(source);
	theApp.emuledlg->transferwnd.downloadlistctrl.AddSource(sender,source,false);
	theApp.emuledlg->transferwnd.downloadlistctrl.UpdateItem(this);
}

void CDownloadQueue::CheckAndAddKnownSource(CPartFile* sender,CUpDownClient* source){
	// use this for client which are already know (downloading for example)
	for (POSITION pos = filelist.GetHeadPosition();pos != 0;filelist.GetNext(pos)){
		CPartFile* cur_file = filelist.GetAt(pos);
		if (cur_file->srclist.Find(source)){
			if (cur_file == sender)
				return;
			if (source->AddRequestForAnotherFile(sender))
				theApp.emuledlg->transferwnd.downloadlistctrl.AddSource(sender,source,true);
			return;
		}
	}
	source->reqfile = sender;
	sender->srclist.AddTail(source);
	theApp.emuledlg->transferwnd.downloadlistctrl.AddSource(sender,source,false);
	theApp.emuledlg->transferwnd.downloadlistctrl.UpdateItem(this);
}

bool CDownloadQueue::RemoveSource(CUpDownClient* toremove, bool	updatewindow){
	bool removed = false;
	for (POSITION pos = filelist.GetHeadPosition();pos != 0;filelist.GetNext(pos)){
		CPartFile* cur_file = filelist.GetAt(pos);
		for (POSITION pos2 = cur_file->srclist.GetHeadPosition();pos2 != 0; cur_file->srclist.GetNext(pos2)){
			if (toremove == cur_file->srclist.GetAt(pos2)){
				cur_file->srclist.RemoveAt(pos2);
				removed = true;
				break;
			}
		}
	}
	if (updatewindow){
		toremove->SetDownloadState(DS_NONE);
		theApp.emuledlg->transferwnd.downloadlistctrl.RemoveSource(toremove,0);
	}
	toremove->reqfile = 0;
	return removed;
}

void CDownloadQueue::RemoveFile(CPartFile* toremove){
	for (POSITION pos = filelist.GetHeadPosition();pos != 0;filelist.GetNext(pos)){
		if (toremove == filelist.GetAt(pos)){
			filelist.RemoveAt(pos);
			return;
		}
	}
}

void CDownloadQueue::DeleteAll(){
	POSITION pos;
	for (pos = filelist.GetHeadPosition();pos != 0;filelist.GetNext(pos)){
		CPartFile* cur_file = filelist.GetAt(pos);
		cur_file->srclist.RemoveAll();
	}
}

bool CDownloadQueue::SendNextUDPPacket(){
	if (filelist.IsEmpty() || !theApp.serverconnect->IsConnected())
		return false;
	if (!cur_udpserver)
		if (!(cur_udpserver = theApp.serverlist->GetNextServer(cur_udpserver))){
			TRACE("ERROR:SendNextUDPPacket() no server found");
		};

	// get nextfile
	CPartFile* nextfile = 0;
	while (!(nextfile && (nextfile->GetStatus() == PS_READY ||nextfile->GetStatus() == PS_EMPTY))){
		if (lastfile == 0){
			nextfile = filelist.GetHead();
			lastfile = nextfile;
		}
		else{
			POSITION pos = filelist.Find(lastfile);
			if (!pos){
				TRACE("Error: CDownloadQueue::SendNextUDPPacket()");
				nextfile = filelist.GetHead();
				lastfile = nextfile;
			}
			else{
				filelist.GetNext(pos);
				if (pos == 0){
					cur_udpserver = theApp.serverlist->GetNextServer(cur_udpserver);
					if (cur_udpserver == 0){
						TRACE("finished");
						lastudpsearchtime = ::GetTickCount();
						lastfile = 0;
						return false; // finished (processed all file & all servers)
					}
					nextfile = filelist.GetHead();
					lastfile = nextfile;
				}
				else{
					nextfile = filelist.GetAt(pos);
					lastfile = nextfile;
				}
			}
		}
	}

	Packet packet(OP_GLOBGETSOURCES,16);
	memcpy(packet.pBuffer,nextfile->GetFileHash(),16);
	if (cur_udpserver != theApp.serverconnect->GetCurrentServer())
		theApp.serverconnect->SendUDPPacket(&packet,cur_udpserver->GetFullIP(),false);
	return true;
}

void CDownloadQueue::SortByPriority(){
   POSITION pos1, pos2;
   uint16 i = 0;
   for( pos1 = filelist.GetHeadPosition(); ( pos2 = pos1 ) != NULL; ){
	   filelist.GetNext(pos1);
	   CPartFile* cur_file = filelist.GetAt(pos2);
	   if (cur_file->GetPriority() == PR_HIGH){
		   filelist.AddHead(cur_file);
		   filelist.RemoveAt(pos2);
	   }
	   else if (cur_file->GetPriority() == PR_LOW){
		   filelist.AddTail(cur_file);
		   filelist.RemoveAt(pos2);
	   }
	   i++;
	   if (i == filelist.GetCount())
		   break;
   }
}
