//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "types.h"
#include "partfile.h"
#include "memdc.h"
#include "titlemenu.h"

struct CtrlItem_Struct{
	uint8	type;
	void*	owner;
	void*	value;
};

// CDownloadListCtrl
class CDownloadListCtrl : public CListCtrl
{
	DECLARE_DYNAMIC(CDownloadListCtrl)

public:
	CDownloadListCtrl();
	virtual ~CDownloadListCtrl();
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	void	UpdateItem(void* toupdate);
	void	Init();
	void	AddFile(CPartFile* toadd);
	void	AddSource(CPartFile* owner,CUpDownClient* source,bool notavailable);
	void	RemoveSource(CUpDownClient* source,CPartFile* owner);
	void	RemoveFile(CPartFile* toremove);
	void	ClearCompleted();
	virtual BOOL OnCommand(WPARAM wParam,LPARAM lParam );
protected:
	afx_msg void OnLvnItemActivate(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMReleasedcapture(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnNMRclick(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg	void OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult);
	static int CALLBACK SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);
	DECLARE_MESSAGE_MAP()
private:
	CTypedPtrList<CPtrList, CtrlItem_Struct*> listcontent;
	CImageList imagelist;
	CTitleMenu	   m_FileMenu;
	CTitleMenu	   m_ClientMenu;
	CMenu		   m_PrioMenu;
	bool		 asc_sort[7];
};


