//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// DownloadListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "DownloadListCtrl.h"
#include "otherfunctions.h" 
#include "updownclient.h"
#include "opcodes.h"
#include "ClientDetailDialog.h"

// CDownloadListCtrl

// hmm some parts here might be overkill ;) ...
// oh well at least I can do/draw/paint everything I want in this window now ;)

IMPLEMENT_DYNAMIC(CDownloadListCtrl, CListBox)
CDownloadListCtrl::CDownloadListCtrl(){
	memset(&asc_sort,0,7);
}

CDownloadListCtrl::~CDownloadListCtrl(){
	for (POSITION pos = listcontent.GetHeadPosition();pos != 0;listcontent.GetNext(pos))
		delete listcontent.GetAt(pos);
}

void CDownloadListCtrl::Init(){
	CImageList m_ImageList; //dummy list
	m_ImageList.Create(1, 17,ILC_COLOR, 1, 1); 
	SetImageList(&m_ImageList, LVSIL_SMALL);
	SetExtendedStyle(LVS_EX_ONECLICKACTIVATE|LVS_EX_FULLROWSELECT);

	InsertColumn(0,"File Name",LVCFMT_LEFT,260);
	InsertColumn(1,"Size",LVCFMT_LEFT,60);
	InsertColumn(2,"Transfered",LVCFMT_LEFT,65);
	InsertColumn(3,"Speed",LVCFMT_LEFT,65);
	InsertColumn(4,"Progress",LVCFMT_LEFT,170);
	InsertColumn(5,"Sources",LVCFMT_LEFT,50);
	InsertColumn(6,"Priority",LVCFMT_LEFT,55);

	imagelist.Create(15,15,ILC_COLOR32,0,10);
	imagelist.SetBkColor(GetBkColor());
	imagelist.Add(theApp.LoadIcon(IDI_DCS1));
	imagelist.Add(theApp.LoadIcon(IDI_DCS2));
	imagelist.Add(theApp.LoadIcon(IDI_DCS3));
	imagelist.Add(theApp.LoadIcon(IDI_DCS4));
	imagelist.Add(theApp.LoadIcon(IDI_COMPPROT));
	m_PrioMenu.CreateMenu();
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOLOW,"Low");
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIONORMAL,"Normal");
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOHIGH, "High");

	m_FileMenu.CreatePopupMenu();
	m_FileMenu.AddMenuTitle("Downloads");
	m_FileMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_PrioMenu.m_hMenu, (LPCTSTR)"Priority");
	
	m_FileMenu.AppendMenu(MF_STRING,MP_CANCEL, (LPCTSTR)"Cancel");
	m_FileMenu.AppendMenu(MF_STRING,MP_STOP, (LPCTSTR)"Stop");
	m_FileMenu.AppendMenu(MF_STRING,MP_PAUSE, (LPCTSTR)"Pause");
	m_FileMenu.AppendMenu(MF_STRING,MP_RESUME, (LPCTSTR)"Resume");
	m_FileMenu.AppendMenu(MF_SEPARATOR);
	m_FileMenu.AppendMenu(MF_STRING,MP_CLEARCOMPLETED, (LPCTSTR)"Clear Completed");
	SetMenu(&m_FileMenu);

	m_ClientMenu.CreatePopupMenu();
	m_ClientMenu.AddMenuTitle("Clients");
	m_ClientMenu.AppendMenu(MF_STRING,MP_DETAIL, (LPCTSTR)"Show Details");
	m_ClientMenu.AppendMenu(MF_STRING,MP_MESSAGE, (LPCTSTR)"Send Message");
}

void CDownloadListCtrl::AddFile(CPartFile* toadd){
	CtrlItem_Struct* newitem = new CtrlItem_Struct;
	uint16 itemnr = GetItemCount();
	newitem->owner = 0;
	newitem->type = 1;
	newitem->value = toadd;
	listcontent.AddTail(newitem);
	InsertItem(LVIF_PARAM,itemnr,0,0,0,0,(LPARAM)newitem);
}

void CDownloadListCtrl::AddSource(CPartFile* owner,CUpDownClient* source,bool notavailable){
	
	CtrlItem_Struct* newitem = new CtrlItem_Struct;
	newitem->owner = owner;
	newitem->type = (notavailable)? 3:2;
	newitem->value = source;
	listcontent.AddTail(newitem);
	if (!owner->srcarevisible)
		return;
	CtrlItem_Struct* search = 0;
	for (POSITION pos = listcontent.GetHeadPosition();pos != 0;listcontent.GetNext(pos)){
		if (listcontent.GetAt(pos)->value == owner){
			search = listcontent.GetAt(pos);
			break;
		}
	}
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)search;
	uint16 itemnr = FindItem(&find);
	while (GetItemCount() > itemnr+1 && ((CtrlItem_Struct*)GetItemData(itemnr+1))->type != 1)
		itemnr++;
	InsertItem(LVIF_PARAM,itemnr+1,0,0,0,0,(LPARAM)newitem);
}

void CDownloadListCtrl::RemoveSource(CUpDownClient* source,CPartFile* owner){
   POSITION pos1, pos2;
   for( pos1 = listcontent.GetHeadPosition(); ( pos2 = pos1 ) != NULL; ){
	   listcontent.GetNext(pos1);
	   CtrlItem_Struct* delitem = listcontent.GetAt(pos2);
	   if(delitem->value == source && (delitem->owner == owner || (!owner) ) ){
 			LVFINDINFO find;
			find.flags = LVFI_PARAM;
			find.lParam = (LPARAM)delitem;
			sint16 result = FindItem(&find);
			if (result != (-1))
				DeleteItem(result);
			listcontent.RemoveAt(pos2);
			delete delitem;
       }
   }
}

void CDownloadListCtrl::RemoveFile(CPartFile* toremove){
   POSITION pos1, pos2;
   for( pos1 = listcontent.GetHeadPosition(); ( pos2 = pos1 ) != NULL; ){
	   CtrlItem_Struct* delitem = listcontent.GetNext(pos1);    
	   if(delitem->value == toremove){
 			LVFINDINFO find;
			find.flags = LVFI_PARAM;
			find.lParam = (LPARAM)delitem;
			sint16 result = FindItem(&find);
			if (result != -1)
				DeleteItem(result);
			listcontent.RemoveAt(pos2);
			delete[] delitem;
			return;
       }
   }
}

void CDownloadListCtrl::UpdateItem(void* toupdate){
	CtrlItem_Struct* search = 0;
	for (POSITION pos = listcontent.GetHeadPosition();pos != 0;listcontent.GetNext(pos)){
		if (listcontent.GetAt(pos)->value == toupdate){
			search = listcontent.GetAt(pos);
			LVFINDINFO find;
			find.flags = LVFI_PARAM;
			find.lParam = (LPARAM)search;
			sint16 result = FindItem(&find);
			if (result != -1)
				Update(result);
			return;
		}
	}
}

void CDownloadListCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct){
	if (!lpDrawItemStruct->itemData)
		return;
	CtrlItem_Struct* content = (CtrlItem_Struct*)lpDrawItemStruct->itemData;
	//CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	CMemDC dc(CDC::FromHandle(lpDrawItemStruct->hDC),&CRect(lpDrawItemStruct->rcItem));
	dc.SelectObject(GetFont());
	
	COLORREF crOldTextColor = dc->GetTextColor();
	COLORREF crOldBkColor = dc->GetBkColor();
	RECT sel_rec;
	memcpy(&sel_rec,&lpDrawItemStruct->rcItem,sizeof(RECT));
	sel_rec.bottom--;
	sel_rec.top++;
	RECT cur_rec;
	memcpy(&cur_rec,&lpDrawItemStruct->rcItem,sizeof(RECT));

	if (content->type == 1){
		CPartFile* partfile = (CPartFile*)content->value;

		if ((lpDrawItemStruct->itemAction | ODA_SELECT) && (lpDrawItemStruct->itemState & ODS_SELECTED))
			dc->SetTextColor(RGB(255,0,0));
		char buffer[200];
		// file name
		cur_rec.right = GetColumnWidth(0);
		cur_rec.left += 4;
		dc->DrawText(partfile->GetFileName(),strlen(partfile->GetFileName()),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);
		//size
		cur_rec.left = cur_rec.right+4;
		cur_rec.right += GetColumnWidth(1);
		CastItoXBytes(partfile->GetFileSize(),buffer);
		dc->DrawText(buffer,strlen(buffer),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);
		// transfered
		cur_rec.left = cur_rec.right+4;
		cur_rec.right += GetColumnWidth(2);
		CastItoXBytes(partfile->GetTransfered(),buffer);
		dc->DrawText(buffer,strlen(buffer),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);	
		// speed
		cur_rec.left = cur_rec.right+4;
		cur_rec.right += GetColumnWidth(3);
		sprintf(buffer,"%.1f KB/s",(float)partfile->GetDatarate()/1024);
		dc->DrawText(buffer,strlen(buffer),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);

		// Progress
		cur_rec.left = cur_rec.right;
		cur_rec.right += GetColumnWidth(4);
		cur_rec.bottom--;
		cur_rec.top++;
		partfile->DrawStatusBar(dc,&cur_rec);
		cur_rec.bottom++;
		cur_rec.top--;
		//sources
		cur_rec.left = cur_rec.right+4;
		cur_rec.right += GetColumnWidth(5);
		sprintf(buffer,"%i (%i)",partfile->GetSourceCount(),partfile->GetTransferingSrcCount());
		dc->DrawText(buffer,strlen(buffer),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);
		//prio
		cur_rec.left = cur_rec.right+4;
		cur_rec.right += GetColumnWidth(5);
		if (partfile->GetStatus() != PS_PAUSED){
			switch(partfile->GetPriority()){
			case 0:
				dc->DrawText("Low",3,&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);
				break;
			case 1:
				dc->DrawText("Normal",6,&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);
				break;
			case 2:
				dc->DrawText("High",4,&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);
				break;
			}
		}
		else
			dc->DrawText("Paused",6,&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);

	}
	else if (content->type == 3 || content->type == 2){
		CUpDownClient* client = (CUpDownClient*)content->value;
		//icon, name, status
		cur_rec.left += 17;
		cur_rec.right = GetColumnWidth(0)+GetColumnWidth(1);
		char* status;
		POINT point= {cur_rec.left,cur_rec.top+1};
		if (content->type == 2){
			switch (client->GetDownloadState()){
				case DS_CONNECTING:
					imagelist.Draw(dc,2, point,ILD_NORMAL);
					status = "Connecting";
					break;
				case DS_CONNECTED:
					imagelist.Draw(dc,2, point,ILD_NORMAL);
					status = "Asking";
					break;
				case DS_WAITCALLBACK:
					imagelist.Draw(dc,2, point,ILD_NORMAL);
					status = "Connecting via server";
					break;
				case DS_ONQUEUE:
					imagelist.Draw(dc,1, point,ILD_NORMAL);
					status = "On Queue";
					break;
				case DS_DOWNLOADING:
					imagelist.Draw(dc,0, point,ILD_NORMAL);
					status = "Transfering";
					break;
				case DS_REQHASHSET:
					imagelist.Draw(dc,0, point,ILD_NORMAL);
					status = "Receiving hashset";
					break;
				case DS_NONEEDEDPARTS:
					imagelist.Draw(dc,3, point,ILD_NORMAL);
					status = "No needed parts";
					break;
				case DS_LOWTOLOWIP:
					imagelist.Draw(dc,3, point,ILD_NORMAL);
					status = "Cannot connect LowID to LowID";
					break;
				default:
					status = "Unknown";
			}
		}
		else{
			
			imagelist.Draw(dc,3, point,ILD_NORMAL);
			status = "Asked for another file";
		}
		cur_rec.left += 20;

		if (client->ExtProtocolAvailable()){
			POINT point2= {cur_rec.left,cur_rec.top+1};
			imagelist.Draw(dc,4, point2,ILD_NORMAL);
			cur_rec.left += 20;
		}

		char* buffer1;
		if (!client->GetUserName()){
			buffer1 = new char[50];
			sprintf(buffer1,"?  (%s)",status);
		}
		else{
			buffer1 = new char[strlen(client->GetUserName())+50];
			sprintf(buffer1,"%s  (%s)",client->GetUserName(),status);
		}
		dc->DrawText(buffer1,strlen(buffer1),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);
		delete[] buffer1;

		char buffer[100];		
		// transfered
		cur_rec.left = cur_rec.right+4;
		cur_rec.right += GetColumnWidth(2);
		if (content->type == 2){
			CastItoXBytes(client->GetTransferedDown(),buffer);
			dc->DrawText(buffer,strlen(buffer),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);	
		}
		// speed
		cur_rec.left = cur_rec.right+4;
		cur_rec.right += GetColumnWidth(3);
		if (content->type == 2){
			sprintf(buffer,"%.1f KB/s",(float)client->GetDownloadDatarate()/1024);
			dc->DrawText(buffer,strlen(buffer),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);
		}
		// file info
		cur_rec.left = cur_rec.right;
		cur_rec.right += GetColumnWidth(4);
		client->DrawStatusBar(dc,&cur_rec,(content->type == 3));

		//sources
		cur_rec.left = cur_rec.right+4;
		cur_rec.right += GetColumnWidth(5);
		//prio
		cur_rec.left = cur_rec.right+4;
		cur_rec.right += GetColumnWidth(5);
		if (client->GetRemoteQueueRank()){
			sprintf(buffer,"QR: %o",client->GetRemoteQueueRank());
			dc->DrawText(buffer,strlen(buffer),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER);
		}
	}
	dc->SetTextColor(crOldTextColor);
	dc->SetBkColor(crOldBkColor);

}


BEGIN_MESSAGE_MAP(CDownloadListCtrl, CListCtrl)
	ON_NOTIFY_REFLECT(LVN_ITEMACTIVATE, OnLvnItemActivate)
	ON_WM_ERASEBKGND()
	ON_NOTIFY_REFLECT (NM_RCLICK, OnNMRclick)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
END_MESSAGE_MAP()



// CDownloadListCtrl message handlers

void CDownloadListCtrl::OnLvnItemActivate(NMHDR *pNMHDR, LRESULT *pResult){
	LPNMITEMACTIVATE pNMIA = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	
	CtrlItem_Struct* content = (CtrlItem_Struct*)this->GetItemData(pNMIA->iItem);

	if (content->type == 1){
		SetRedraw(false);

		CPartFile* partfile = (CPartFile*)content->value;
		if (!partfile->srcarevisible){
			for (POSITION pos = listcontent.GetHeadPosition();pos != 0;listcontent.GetNext(pos)){
				if (listcontent.GetAt(pos)->owner == partfile)
					InsertItem(LVIF_PARAM,pNMIA->iItem+1,0,0,0,0,(LPARAM)listcontent.GetAt(pos));
			}
			partfile->srcarevisible = true;
		}
		else{
			while (GetItemCount() > pNMIA->iItem+1 && ((CtrlItem_Struct*)GetItemData(pNMIA->iItem+1))->type != 1)
				DeleteItem(pNMIA->iItem+1);
			partfile->srcarevisible = false;
		}
		SetRedraw(true);
	}
	*pResult = 0;
}


BOOL CDownloadListCtrl::OnEraseBkgnd(CDC* pDC) {
	// flickerfree, draw only on places backgroud where we need background and not one pixel more ;)  
	uint16 count = GetItemCount();
	if (!count)
		return CListCtrl::OnEraseBkgnd(pDC);
	RECT clientrect;
	GetClientRect(&clientrect);
	RECT itemheigth;
	GetItemRect(0,&itemheigth,LVIR_BOUNDS);
	clientrect.bottom = itemheigth.top;
	pDC->FillSolidRect(&clientrect,GetBkColor());

	GetClientRect(&clientrect);
	if ((count+1)*(itemheigth.bottom - itemheigth.top) < clientrect.bottom){
		clientrect.top = (count+1)*(itemheigth.bottom - itemheigth.top);
		pDC->FillSolidRect(&clientrect,GetBkColor());	
	}
	else if (GetScrollLimit(SB_LINERIGHT) && GetScrollLimit(SB_LINERIGHT) == GetScrollPos(SB_LINERIGHT)){
		clientrect.top = clientrect.bottom - (itemheigth.bottom - itemheigth.top);
		pDC->FillSolidRect(&clientrect,GetBkColor());	
	}

	GetClientRect(&clientrect);
	if (itemheigth.right < clientrect.right){
		clientrect.left = itemheigth.right;
		pDC->FillSolidRect(&clientrect,GetBkColor());
	}
	return true;
}

void CDownloadListCtrl::OnNMRclick(NMHDR *pNMHDR, LRESULT *pResult){	
	POINT point;
	::GetCursorPos(&point);
	if (GetSelectionMark() != (-1)){
		CtrlItem_Struct* content = (CtrlItem_Struct*)this->GetItemData(GetSelectionMark());
		if (content->type == 1){
			CPartFile* file = (CPartFile*)content->value;
			m_FileMenu.EnableMenuItem(MP_PAUSE,((file->GetStatus() != PS_PAUSED) ? MF_ENABLED:MF_GRAYED));
			m_FileMenu.EnableMenuItem(MP_STOP,((file->GetStatus() != PS_PAUSED) ? MF_ENABLED:MF_GRAYED));
			m_FileMenu.EnableMenuItem(MP_RESUME,((file->GetStatus() == PS_PAUSED) ? MF_ENABLED:MF_GRAYED));
			m_FileMenu.EnableMenuItem(MP_CANCEL,MF_ENABLED);

			m_PrioMenu.CheckMenuItem(MP_PRIOHIGH,(file->GetPriority() == PR_HIGH)? MF_CHECKED:MF_UNCHECKED);
			m_PrioMenu.CheckMenuItem(MP_PRIONORMAL,(file->GetPriority() == PR_NORMAL)? MF_CHECKED:MF_UNCHECKED);
			m_PrioMenu.CheckMenuItem(MP_PRIOLOW,(file->GetPriority() == PR_LOW)? MF_CHECKED:MF_UNCHECKED);
			m_FileMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
		}else
			m_ClientMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
	}
	else{
		m_FileMenu.EnableMenuItem(MP_CANCEL,MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_PAUSE,MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_STOP,MF_GRAYED);
		m_FileMenu.EnableMenuItem(MP_RESUME,MF_GRAYED);
		m_FileMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
	}
	*pResult = 0;
}

BOOL CDownloadListCtrl::OnCommand(WPARAM wParam,LPARAM lParam ){
	if (GetSelectionMark() != (-1)){
		CtrlItem_Struct* content = (CtrlItem_Struct*)this->GetItemData(GetSelectionMark());
		
		if (content->type == 1){
			CPartFile* file = (CPartFile*)content->value;
			
			switch (wParam){
				case MP_CANCEL:{
					switch(file->GetStatus()){
						case PS_WAITINGFORHASH:
						case PS_HASHING:
						case PS_COMPLETING:
						case PS_COMPLETE:
							break;
						default:
							if (MessageBox("Are you sure that you want to cancel and delete this file?","Cancel",MB_ICONQUESTION|MB_YESNO) == IDYES)
									file->DeleteFile();
					}
					break;
	
				}
				case MP_PRIOHIGH:
					file->SetPriority(PR_HIGH);
					break;
				case MP_PRIOLOW:
					file->SetPriority(PR_LOW);
					break;
				case MP_PRIONORMAL:
					file->SetPriority(PR_NORMAL);
					break;
				case MP_PAUSE:
					file->PauseFile();
					break;
				case MP_RESUME:
					file->ResumeFile();
					break;
				case MP_STOP:
					file->StopFile();
					break;
				case MP_CLEARCOMPLETED:
					ClearCompleted();
					break;
			}
		}
		else{
			CUpDownClient* client = (CUpDownClient*)content->value;
			switch (wParam){
				case MP_MESSAGE:
					theApp.emuledlg->chatwnd.StartSession(client);
					break;
				case MP_DETAIL:
					CClientDetailDialog dialog(client);
					dialog.DoModal();
					break;
			}
		}
	}
	else /*nothing selected*/
	{
		switch (wParam){
			case MP_CLEARCOMPLETED:
				ClearCompleted();
				break;
		}

	}

	return true;
}

void CDownloadListCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult){
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// if it's a second click on the same column then reverse the sort order,
	// otherwise sort the new column in ascending order.
	asc_sort[pNMListView->iSubItem] = !asc_sort[pNMListView->iSubItem];
	SortItems(&SortProc,pNMListView->iSubItem+ ((asc_sort[pNMListView->iSubItem])? 0:10));
	*pResult = 0;
}

int CDownloadListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort){
	CtrlItem_Struct* item1 = (CtrlItem_Struct*)lParam1;
	CtrlItem_Struct* item2 = (CtrlItem_Struct*)lParam2;
	if ((item1->type == 1 && item2->type != 1) || (item2->type == 1 && item1->type != 1))
		return 0;
	if (item1->type == 1){
		CPartFile* file1 = (CPartFile*)item1->value;
		CPartFile* file2 = (CPartFile*)item2->value;
		if (file1->srcarevisible || file2->srcarevisible)
			return 0;
		switch(lParamSort){
			case 0: //filename asc
				return strcmp(file1->GetFileName(),file2->GetFileName());
			case 10: //filename desc
				return strcmp(file2->GetFileName(),file1->GetFileName());
			case 1: //size asc
				return file2->GetFileSize() - file1->GetFileSize();
			case 11: //size desc
				return file1->GetFileSize() - file2->GetFileSize();
			case 2: //transfered asc
				return file2->GetTransfered() - file1->GetTransfered();
			case 12: //transfered desc
				return file1->GetTransfered() - file2->GetTransfered();
			case 3: //speed asc
				return file2->GetDatarate() - file1->GetDatarate();
			case 13: //speed desc
				return file1->GetDatarate() - file2->GetDatarate();
			case 4: //progress asc
				return file2->GetPercentCompleted() - file1->GetPercentCompleted();
			case 14: //progress desc
				return file1->GetPercentCompleted() - file2->GetPercentCompleted();
			case 5: //sources asc
				return file2->GetSourceCount() - file1->GetSourceCount();
			case 15: //sources desc
				return file1->GetSourceCount() - file2->GetSourceCount();
			case 6: //priority asc
				return file2->GetPriority() - file1->GetPriority();
			case 16: //priority desc
				return file1->GetPriority() - file2->GetPriority();
			default:
				return 0;
		}
	}
	else{
		CUpDownClient* client1 = (CUpDownClient*)item1->value;
		CUpDownClient* client2 = (CUpDownClient*)item2->value;
		if (item1->type != item2->type)
			return item1->type - item2->type; 
		switch(lParamSort){
			case 0: //name asc
				if (!client1->GetUserName())
					return 1;
				else if(!client2->GetUserName())
					return -1;
				return strcmp(client1->GetUserName(),client2->GetUserName());
			case 10: //name desc
				if (!client1->GetUserName())
					return -1;
				else if(!client2->GetUserName())
					return 1;
				return strcmp(client2->GetUserName(),client1->GetUserName());
			case 1: //size but we use status asc
				return client2->GetDownloadState() - client1->GetDownloadState();
			case 11: //size but we use status desc
				return client1->GetDownloadState() - client2->GetDownloadState();
			case 2: //transfered asc
				return client2->GetTransferedDown() - client1->GetTransferedDown();
			case 12: //transfered desc
				return client1->GetTransferedDown() - client2->GetTransferedDown();
			case 3: //speed asc
				return client1->GetDownloadDatarate() - client2->GetDownloadDatarate();
			case 13: //speed desc
				return client2->GetDownloadDatarate() - client1->GetDownloadDatarate();
			case 4: //progress asc
				return client2->GetAvailablePartCount() - client1->GetAvailablePartCount();
			case 14: //progress desc
				return client1->GetAvailablePartCount() - client2->GetAvailablePartCount();
			default:
				return 0;
		}

	}
}

void CDownloadListCtrl::ClearCompleted(){
   POSITION pos1, pos2;
   for( pos1 = listcontent.GetHeadPosition(); ( pos2 = pos1 ) != NULL; ){
	   listcontent.GetNext(pos1);
	   CtrlItem_Struct* delitem = listcontent.GetAt(pos2);
	   if (delitem->type == 1){
		   CPartFile* file = (CPartFile*)delitem->value;
		   if (!file->IsPartFile())
			   RemoveFile(file);
	   }
   }
}