//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "StdAfx.h"
#include "zlib/zlib.h"
#include "updownclient.h"
#include "partfile.h"
#include "opcodes.h"
#include "packets.h"
#include "emule.h"


//	members of CUpDownClient
//	which are mainly used for downloading functions 

void CUpDownClient::DrawStatusBar(CDC* dc, RECT* rect, bool onlygreyrect){
	RECT gaprect;
	gaprect.top = rect->top + 2;
	gaprect.bottom = rect->bottom-2;
	gaprect.left = rect->left;
	gaprect.right = rect->right;
	dc->FillRect(&gaprect,&CBrush(RGB(220,220,220)));
	if (onlygreyrect)
		return;
	if (!reqfile || !partstatus)
		return;
	float blockpixel = (float)(rect->right - rect->left)/((float)(reqfile->GetFileSize()+1)/1024);
	for (int i = 0;i != partcount;i++){
		if (partstatus[i]){
			gaprect.right = rect->left + (uint32)(((float)PARTSIZE*i/1024)*blockpixel);
			if (PARTSIZE*(i+1) > reqfile->GetFileSize())
				gaprect.left = rect->left +  (uint32)((float)((float)reqfile->GetFileSize()/1024)*blockpixel);
			else
				gaprect.left = rect->left +  (uint32)((float)((float)PARTSIZE*(i+1)/1024)*blockpixel);
			if (reqfile->IsComplete(PARTSIZE*i,PARTSIZE*(i+1)-1))
				dc->FillRect(&gaprect,&CBrush(RGB(0,150,0)));
			else
				dc->FillRect(&gaprect,&CBrush(RGB(0,0,0)));
		}
	}
}

bool CUpDownClient::Compare(CUpDownClient* tocomp){
	if (HasLowID())
		return ((this->GetUserID() == tocomp->GetUserID()) && (GetServerIP() == tocomp->GetServerIP()));
	else
		return (this->GetUserID() == tocomp->GetUserID());
}

void CUpDownClient::AskForDownload(){
	lastaskedtime = ::GetTickCount();
	SetDownloadState(DS_CONNECTING);
	TryToConnect();

}

void CUpDownClient::SendFileRequest(){
	Packet* packet = new Packet(OP_FILEREQUEST,16);
	memcpy(packet->pBuffer,reqfile->GetFileHash(),16);
	socket->SendPacket(packet,false);
	packet->opcode = OP_SETREQFILEID;
	socket->SendPacket(packet,true);
	SetRemoteQueueRank(0);
}

void CUpDownClient::ProcessFileInfo(char* packet,uint32 size){
	CMemFile* data = new CMemFile((BYTE*)packet,size);
	uchar cfilehash[16];
	data->Read(cfilehash,16);
	uint16 namelength;
	data->Read(&namelength,2);
	if (clientfilename)
		delete[] clientfilename;
	clientfilename = new char[namelength+1];
	data->Read(clientfilename,namelength);
	delete data;
	if ( (!reqfile) || memcmp(cfilehash,reqfile->GetFileHash(),16))
		throw "wrong fileid sent (ProcessFileInfo)";
}

void CUpDownClient::ProcessFileStatus(char* packet,uint32 size){
	CMemFile* data = new CMemFile((BYTE*)packet,size);
	uchar cfilehash[16];
	data->Read(cfilehash,16);
	if ( (!reqfile) || memcmp(cfilehash,reqfile->GetFileHash(),16))
		throw "wrong fileid sent (ProcessFileStatus)";	
	data->Read(&partcount,2);
	if (partstatus)
		delete[] partstatus;
	bool partsneeded = false;
	if (!partcount){
		partcount = reqfile->GetPartCount();
		partstatus = new uint8[partcount];
		memset(partstatus,1,partcount);
		partsneeded = true;
	}
	else{
		if (reqfile->GetPartCount() != partcount)
			throw "wrong part number";
		partstatus = new uint8[partcount];
		uint16 done = 0;
		while (done != partcount){
			uint8 toread;
			data->Read(&toread,1);
			for (sint32 i = 0;i != 8;i++){
				partstatus[done] = ((toread>>i)&1)? 1:0; 	
				if (partstatus[done] && !reqfile->IsComplete(done*PARTSIZE,((done+1)*PARTSIZE)-1))
					partsneeded = true;
				done++;
				if (done == partcount)
					break;
			}
		}

	}
	theApp.emuledlg->transferwnd.downloadlistctrl.UpdateItem(this);
	
	if (!partsneeded)
		SetDownloadState(DS_NONEEDEDPARTS);
	else if (reqfile->hashsetneeded){
		Packet* packet = new Packet(OP_HASHSETREQUEST,16);
		memcpy(packet->pBuffer,reqfile->GetFileHash(),16);
		socket->SendPacket(packet,true,true);
		SetDownloadState(DS_REQHASHSET);
		reqfile->hashsetneeded = false;
	}
	else{
		SetDownloadState(DS_ONQUEUE);
		Packet* packet = new Packet(OP_STARTUPLOADREQ,0);
		socket->SendPacket(packet,true,true);
	}
		
	reqfile->NewSrcPartsInfo();
	delete data;
}

bool CUpDownClient::AddRequestForAnotherFile(CPartFile* file){
	for (POSITION pos = otherrequests_list.GetHeadPosition();pos != 0;otherrequests_list.GetNext(pos)){
		if (otherrequests_list.GetAt(pos) == file)
			return false;
	}
	otherrequests_list.AddTail(file);
	return true;
}

void CUpDownClient::SetDownloadState(uint8 news){
	if (substate != news){
		if (substate == DS_DOWNLOADING ){
			substate = news;
	

			for (POSITION pos = downloadblocks_list.GetHeadPosition();pos != 0;downloadblocks_list.GetNext(pos)){
				Requested_Block_Struct* cur_block = downloadblocks_list.GetAt(pos);
				reqfile->RemoveBlockFromList(cur_block->StartOffset,cur_block->EndOffset);
				delete downloadblocks_list.GetAt(pos);
			}
			downloadblocks_list.RemoveAll();

			for (POSITION pos = pendingblocks_list.GetHeadPosition();pos != 0;pendingblocks_list.GetNext(pos)){
				Requested_Block_Struct* cur_block = pendingblocks_list.GetAt(pos)->block;
				if (reqfile)
					reqfile->RemoveBlockFromList(cur_block->StartOffset,cur_block->EndOffset);
				delete pendingblocks_list.GetAt(pos)->block;
				delete pendingblocks_list.GetAt(pos)->buffer;
				delete pendingblocks_list.GetAt(pos);
			}
			pendingblocks_list.RemoveAll();
			reqfile = 0;
			downdatarate = 0;
			if (news == DS_NONE){
				if (partstatus)
					delete[] partstatus;
				partstatus = 0;
			}
			if (socket && news != DS_ERROR)
					socket->DisableDownloadLimit();
		}
		substate = news;
		theApp.emuledlg->transferwnd.downloadlistctrl.UpdateItem(this);
	}
}

void CUpDownClient::ProcessHashSet(char* packet,uint32 size){
	if ( (!reqfile) || memcmp(packet,reqfile->GetFileHash(),16))
		throw "wrong fileid sent (ProcessHashSet)";	
	CMemFile* data = new CMemFile((BYTE*)packet,size);
	if (reqfile->LoadHashsetFromFile(data)){
		
	}
	else{
		reqfile->hashsetneeded = true;
		throw "corrupted or invalid hashset received";
	}
	SetDownloadState(DS_ONQUEUE);
	Packet* opacket = new Packet(OP_STARTUPLOADREQ,0);
	socket->SendPacket(opacket,true,true);
	delete data;
}

void CUpDownClient::SendBlockRequests(){
	lastblockreceived = ::GetTickCount();
	if (!reqfile)
		return;
	if (downloadblocks_list.IsEmpty()){
		uint16 count;
		Requested_Block_Struct** toadd = new Requested_Block_Struct*[3];
		if (reqfile->GetNextRequestedBlock(this,toadd,&count)){
			for (int i = 0; i != count; i++)
				downloadblocks_list.AddTail(toadd[i]);			
		}
		delete[] toadd;
	}
	while (pendingblocks_list.GetCount() < 3 && !downloadblocks_list.IsEmpty()){
		Pending_Block_Struct* pblock = new Pending_Block_Struct;
		pblock->block = downloadblocks_list.RemoveHead();
		pblock->buffer = new CMemFile(10240);
		pendingblocks_list.AddTail(pblock);
	}
	if (pendingblocks_list.IsEmpty()){
		Packet* packet = new Packet(OP_CANCELTRANSFER,0);
		socket->SendPacket(packet,true,true);
		SetDownloadState(DS_NONEEDEDPARTS);
		return;
	}
	Packet* packet = new Packet(OP_REQUESTPARTS,40);
	CMemFile* data = new CMemFile((BYTE*)packet->pBuffer,40);
	data->Write(reqfile->GetFileHash(),16);
	POSITION pos = pendingblocks_list.GetHeadPosition();
	uint32 null = 0;
	Requested_Block_Struct* block;
	for (i = 0; i != 3; i++){
		if (pos){
			block = pendingblocks_list.GetAt(pos)->block;
			pendingblocks_list.GetNext(pos);
			data->Write(&block->StartOffset,4);
		}
		else
			data->Write(&null,4);
	}
	pos = pendingblocks_list.GetHeadPosition();
	for (i = 0; i != 3; i++){
		if (pos){
			block = pendingblocks_list.GetAt(pos)->block;
			pendingblocks_list.GetNext(pos);
			uint32 endpos = block->EndOffset+1;
			data->Write(&endpos,4);
		}
		else
			data->Write(&null,4);
	}
	delete data;
	socket->SendPacket(packet,true,true);
}

void CUpDownClient::ProcessBlockPacket(char* packet, uint32 size, bool packed){
	if (!(GetDownloadState() == DS_DOWNLOADING || GetDownloadState() == DS_NONEEDEDPARTS))
		return;
	lastblockreceived = ::GetTickCount();
	CMemFile* data = new CMemFile((BYTE*)packet,size);
	uchar fileid[16];
	data->Read(fileid,16);
	if ( (!reqfile) || memcmp(packet,reqfile->GetFileHash(),16))
		throw "wrong fileid sent (ProcessBlockPacket)";
	uint32 startpos;
	uint32 endpos;
	uint32 blocksize = 0;
	data->Read(&startpos,4);
	if (packed){
		data->Read(&blocksize,4);
		endpos = startpos + (size-24);
		usedcompressiondown = true;
	}
	else
		data->Read(&endpos,4);
		
	downdataratems += endpos-startpos;
	transfereddown += endpos-startpos;
	if ( size != (endpos-startpos)+24)
		throw "corrupted or invalid DataBlock received (ProcessBlockPacket)";
	endpos--;
	delete data;

	for (POSITION pos = pendingblocks_list.GetHeadPosition();pos != 0;pendingblocks_list.GetNext(pos)){
		Pending_Block_Struct* cur_block = pendingblocks_list.GetAt(pos);
		if (cur_block->block->StartOffset <= startpos && cur_block->block->EndOffset >= endpos){
			cur_block->buffer->Write(packet+24,size-24);
			if (!packed){
				if (endpos == cur_block->block->EndOffset){
					char* blockbuffer = (char*)cur_block->buffer->Detach();
					reqfile->BlockReceived(cur_block->block->StartOffset,cur_block->block->EndOffset,blockbuffer);
					delete cur_block->block;
					delete cur_block->buffer;
					delete cur_block;
					delete[] blockbuffer;
					pendingblocks_list.RemoveAt(pos);
					SendBlockRequests();	
				}
			}
			else{
				if (blocksize == cur_block->buffer->GetLength()){
					BYTE* blockbuffer = cur_block->buffer->Detach();
					BYTE* unpack = new BYTE[BLOCKSIZE+300];
					uLongf unpackedsize;
					uint16 result = uncompress(unpack,&unpackedsize,blockbuffer,blocksize);
					if (result == Z_OK){
						reqfile->BlockReceived(cur_block->block->StartOffset,cur_block->block->StartOffset + (unpackedsize-1),(char*)unpack, blocksize);	
						
					}
					else{
						theApp.emuledlg->AddLogLine(false,"Corrupted compressed packet for %s received",reqfile->GetFileName());
						reqfile->RemoveBlockFromList(cur_block->block->StartOffset,cur_block->block->StartOffset+1);
					}
					delete[] unpack;
					delete cur_block->block;
					delete cur_block->buffer;
					delete cur_block;
					delete[] blockbuffer;
					pendingblocks_list.RemoveAt(pos);
					SendBlockRequests();	
				}
			}
			return;
		}
	}
}

uint32 CUpDownClient::CalculateDownloadRate(){
	avarage_ddr_list.RemoveAt(avarage_ddr_list.GetHeadPosition());
	avarage_ddr_list.AddTail(downdataratems);
	downdatarate = 0;
	downdataratems = 0;
	for (POSITION pos = avarage_ddr_list.GetHeadPosition();pos != 0;avarage_ddr_list.GetNext(pos))
		downdatarate += avarage_ddr_list.GetAt(pos);
	downdatarate /= (avarage_ddr_list.GetCount()/10);
	dcount++;
	if (dcount == 30){
		dcount = 0;
		theApp.emuledlg->transferwnd.downloadlistctrl.UpdateItem(this);
	}
	if ((::GetTickCount() - lastblockreceived) > DOWNLOADTIMEOUT){
		Packet* packet = new Packet(OP_CANCELTRANSFER,0);
		socket->SendPacket(packet,true,true);
		SetDownloadState(DS_ONQUEUE);
	}
		
	return downdatarate;
}

uint16 CUpDownClient::GetAvailablePartCount(){
	uint16 result = 0;
	for (int i = 0;i != partcount;i++){
		if (IsPartAvailable(i))
			result++;
	}
	return result;
}

void CUpDownClient::SetRemoteQueueRank(uint16 nr){
	remotequeuerank = nr;
	theApp.emuledlg->transferwnd.downloadlistctrl.UpdateItem(this);
}