//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ClientDetailDialog.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "ClientDetailDialog.h"
#include "otherfunctions.h"


// CClientDetailDialog dialog

IMPLEMENT_DYNAMIC(CClientDetailDialog, CDialog)
CClientDetailDialog::CClientDetailDialog(CUpDownClient* client)
	: CDialog(CClientDetailDialog::IDD, 0)
{
	m_client = client;
}

CClientDetailDialog::~CClientDetailDialog()
{
}

void CClientDetailDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BOOL CClientDetailDialog::OnInitDialog(){
	CDialog::OnInitDialog();
	LOGFONT lf;
	GetFont()->GetLogFont(&lf);
	lf.lfWeight = FW_BOLD;
	bold.CreateFontIndirect(&lf);
	GetDlgItem(IDC_GENERAL)->SetFont(&bold);
	GetDlgItem(IDC_DTRANS)->SetFont(&bold);
	GetDlgItem(IDC_DSCOREM)->SetFont(&bold);

	char buffer[100];
	if (m_client->GetUserName())
		GetDlgItem(IDC_DNAME)->SetWindowText(m_client->GetUserName());
	else
		GetDlgItem(IDC_DNAME)->SetWindowText("?");
	
	if (m_client->GetUserName()){
		buffer[0] = 0;
		for (uint16 i = 0;i != 16;i++)
			sprintf(buffer,"%s%02X",buffer,m_client->GetUserHash()[i]);
		GetDlgItem(IDC_DHASH)->SetWindowText(buffer);
	}
	else
		GetDlgItem(IDC_DHASH)->SetWindowText("?");
	
	switch(m_client->GetClientSoft()){
		case SO_UNKNOWN:
			GetDlgItem(IDC_DSOFT)->SetWindowText("?");
			GetDlgItem(IDC_DVERSION)->SetWindowText("?");
			break;
		case SO_EMULE:
		case SO_OLDEMULE:
			GetDlgItem(IDC_DSOFT)->SetWindowText("eMule");
			if (m_client->GetMuleVersion()){
				sprintf(buffer,"v0.%02X",m_client->GetMuleVersion());
				GetDlgItem(IDC_DVERSION)->SetWindowText(buffer);
			}
			else
				GetDlgItem(IDC_DVERSION)->SetWindowText("?");
			break;
		case SO_EDONKEY:
			GetDlgItem(IDC_DSOFT)->SetWindowText("eDonkey");
			sprintf(buffer,"v%i",m_client->GetVersion());
			GetDlgItem(IDC_DVERSION)->SetWindowText(buffer);
			break;
	}

	sprintf(buffer,"%o (%s)",m_client->GetUserID(),(m_client->HasLowID() ? "Low":"High"));
	GetDlgItem(IDC_DID)->SetWindowText(buffer);
	
	sprintf(buffer,"%s:%i",m_client->GetFullIP(),m_client->GetUserPort());
	GetDlgItem(IDC_DIP)->SetWindowText(buffer);

	if (m_client->GetServerIP()){
		in_addr server;
		server.S_un.S_addr = m_client->GetServerIP();
		GetDlgItem(IDC_DSIP)->SetWindowText(inet_ntoa(server));
		
		CServer* cserver = theApp.serverlist->GetServerByIP(m_client->GetServerIP());
		if (cserver)
			GetDlgItem(IDC_DSNAME)->SetWindowText(cserver->GetListName());
		else
			GetDlgItem(IDC_DSNAME)->SetWindowText("?");
	}
	else{
		GetDlgItem(IDC_DSIP)->SetWindowText("?");
		GetDlgItem(IDC_DSNAME)->SetWindowText("?");
	}

	CKnownFile* file = theApp.sharedfiles->GetFileByID(m_client->reqfileid);
	if (file)
		GetDlgItem(IDC_DDOWNLOADING)->SetWindowText(file->GetFileName());
	else
		GetDlgItem(IDC_DDOWNLOADING)->SetWindowText("-");


	CastItoXBytes(m_client->GetTransferedDown(),buffer);
	GetDlgItem(IDC_DDUP)->SetWindowText(buffer);

	CastItoXBytes(m_client->GetTransferedUp(),buffer);
	GetDlgItem(IDC_DDOWN)->SetWindowText(buffer);

	sprintf(buffer,"%.1f KB/s",(float)m_client->GetDownloadDatarate()/1024);
	GetDlgItem(IDC_DAVUR)->SetWindowText(buffer);

	sprintf(buffer,"%.1f KB/s",(float)m_client->GetDatarate()/1024);
	GetDlgItem(IDC_DAVDR)->SetWindowText(buffer);

	GetDlgItem(IDC_DDOWNTOTAL)->SetWindowText("?");
	GetDlgItem(IDC_DUPTOTAL)->SetWindowText("?");
	GetDlgItem(IDC_DRATIO)->SetWindowText("?");

	if (m_client->GetUserName()){
		sprintf(buffer,"%.1f",(float)m_client->GetScore(m_client->IsDownloading(),true));
		GetDlgItem(IDC_DRATING)->SetWindowText(buffer);
	}
	else
		GetDlgItem(IDC_DRATING)->SetWindowText("?");;

	if (m_client->GetUploadState() != US_NONE){
		sprintf(buffer,"%o",m_client->GetScore(m_client->IsDownloading(),false));
		GetDlgItem(IDC_DSCORE)->SetWindowText(buffer);
	}
	else
		GetDlgItem(IDC_DSCORE)->SetWindowText("-");
	return true;
}

BEGIN_MESSAGE_MAP(CClientDetailDialog, CDialog)
END_MESSAGE_MAP()


// CClientDetailDialog message handlers
