//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ChatWnd.cpp : implementation file
//
#include "stdafx.h"
#include "emule.h"
#include "ChatWnd.h"
#include "HyperTextCtrl.h"


// CChatWnd dialog

IMPLEMENT_DYNAMIC(CChatWnd, CDialog)
CChatWnd::CChatWnd(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CChatWnd::IDD, pParent)
{
}

CChatWnd::~CChatWnd()
{
}

void CChatWnd::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CHATSEL, chatselector);
}


BEGIN_MESSAGE_MAP(CChatWnd, CResizableDialog)
	ON_BN_CLICKED(IDC_CSEND, OnBnClickedCsend)
	ON_WM_KEYDOWN()
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_CCLOSE, OnBnClickedCclose)
END_MESSAGE_MAP()


// CChatWnd message handlers

BOOL CChatWnd::OnInitDialog(){
	CResizableDialog::OnInitDialog();
	chatselector.Init();

	ShowSizeGrip(FALSE);
	AddAnchor(IDC_CHATSEL,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(chatselector.chatout,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_CMESSAGE,BOTTOM_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_CSEND,BOTTOM_RIGHT);
	AddAnchor(IDC_CCLOSE,BOTTOM_RIGHT);
	AddAnchor(IDC_LIST2,TOP_RIGHT,BOTTOM_RIGHT);
	AddAnchor(IDC_CSTATIC1,TOP_RIGHT);

	return true;
}

void CChatWnd::StartSession(CUpDownClient* client){
	if (!client->GetUserName())
		return;
	theApp.emuledlg->SetActiveDialog(this);
	chatselector.StartSession(client,true);
}

void CChatWnd::OnBnClickedCsend(){
	uint16 len = GetDlgItem(IDC_CMESSAGE)->GetWindowTextLength()+2;
	char* messagetosend = new char[len+1];
	GetDlgItem(IDC_CMESSAGE)->GetWindowText(messagetosend,len);
	if (chatselector.SendMessage(messagetosend))
		GetDlgItem(IDC_CMESSAGE)->SetWindowText("");
	delete[] messagetosend;
}

void CChatWnd::OnShowWindow(BOOL bShow,UINT nStatus){
	if (bShow)
		chatselector.ShowChat();
}

void CChatWnd::OnBnClickedCclose(){
	chatselector.EndSession();
}

BOOL CChatWnd::PreTranslateMessage(MSG* pMsg) 
{
   if((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == 13)){
	   if (pMsg->hwnd == GetDlgItem(IDC_CMESSAGE)->m_hWnd)
			OnBnClickedCsend();
   }

   return CResizableDialog::PreTranslateMessage(pMsg);
}

