//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ChatSelector.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "ChatSelector.h"
#include "packets.h"

CChatItem::CChatItem(){
	log = 0;
	messagepending = 0;
	notify = false;
}

// CChatSelector

IMPLEMENT_DYNAMIC(CChatSelector, CTabCtrl)
CChatSelector::CChatSelector(){

}

CChatSelector::~CChatSelector(){
	//KillTimer();
}


BEGIN_MESSAGE_MAP(CChatSelector, CTabCtrl)
	ON_WM_TIMER()
	ON_NOTIFY_REFLECT(TCN_SELCHANGE, OnTcnSelchangeChatsel)
END_MESSAGE_MAP()



// CChatSelector message handlers
void CChatSelector::Init(){
	RECT rect;
	GetClientRect(&rect);
	rect.top = 30;
	rect.left = 12;
	rect.right -= 4;
	rect.bottom -= 30;
	chatout.CreateEx(WS_EX_STATICEDGE,0,"ChatWnd",WS_VISIBLE | WS_CHILD | HTC_WORDWRAP |HTC_AUTO_SCROLL_BARS | HTC_UNDERLINE_HOVER,rect,this->GetParent(),0);
	chatout.AppendHyperLink(CString("eMule"),0,CString("http://emule.sf.net"),0,0);
	chatout.AppendText(CString(" Version ")+ CString(CURRENT_VERSION_LONG)+ CString(" Instant Messaging\n  \nRight-click on any client and select 'Send Message' to start a chatsession"));
	imagelist.Create(16,16,ILC_COLOR32 ,0,10);
	imagelist.SetBkColor(::GetSysColor(COLOR_BTNFACE));
	imagelist.Add(theApp.LoadIcon(IDI_CHAT));
	imagelist.Add(theApp.LoadIcon(IDI_MESSAGE));
	imagelist.Add(theApp.LoadIcon(IDI_MPENDING));
	SetImageList(&imagelist);
	m_Timer = SetTimer(20,1500,0);

}

CChatItem* CChatSelector::StartSession(CUpDownClient* client, bool show){
	if (GetTabByClient(client) != 0xFFFF){
		if (show){
			SetCurSel(GetTabByClient(client));
			chatout.SetHyperText(GetItemByClient(client)->log);
		}
		return 0;
	}

	CChatItem* chatitem = new CChatItem();
	chatitem->client = client;
	chatitem->log = new CPreparedHyperText();

	CTime theTime = CTime::GetCurrentTime();
	CString sessions = "*** Chatsession Start : "+CString(client->GetUserName()) + " (IP: " + CString(client->GetFullIP()) + ") - " + theTime.Format("%c")+ "\n";
	chatitem->log->AppendKeyWord(sessions,RGB(255,0,0));
	client->SetChatState(MS_CHATTING);

	TCITEM newitem;
	newitem.mask = TCIF_PARAM|TCIF_TEXT|TCIF_IMAGE;
	newitem.lParam = (LPARAM)chatitem;
	newitem.pszText = client->GetUserName();
	newitem.cchTextMax = strlen(client->GetUserName())+1;
	newitem.iImage = 0;
	uint16 itemnr = InsertItem(GetItemCount(),&newitem);
	if (show){
		SetCurSel(itemnr);
		chatout.SetHyperText(chatitem->log);
	}
	return chatitem;
}

uint16 CChatSelector::GetTabByClient(CUpDownClient* client){
	for (int i = 0; i != GetItemCount();i++){
		TCITEM cur_item;
		cur_item.mask = TCIF_PARAM;
		GetItem(i,&cur_item);
		if (((CChatItem*)cur_item.lParam)->client == client)
			return i;
	}
	return -1;
}

CChatItem* CChatSelector::GetItemByClient(CUpDownClient* client){
	for (int i = 0; i != GetItemCount();i++){
		TCITEM cur_item;
		cur_item.mask = TCIF_PARAM;
		GetItem(i,&cur_item);
		if (((CChatItem*)cur_item.lParam)->client == client)
			return (CChatItem*)cur_item.lParam;
	}
	return 0;
}

void CChatSelector::ProcessMessage(CUpDownClient* sender, char* message){
	CChatItem* ci = GetItemByClient(sender);
	if (!ci)
		ci = StartSession(sender,false);
	ci->log->AppendKeyWord(CString(sender->GetUserName()),RGB(50,200,250));
	ci->log->AppendText(CString(": "));
	ci->log->AppendText(CString(message)+ CString("\n"));
	if (GetCurSel() == GetTabByClient(sender) && GetParent()->IsWindowVisible())
		chatout.SetHyperText(ci->log);
	else
		ci->notify = true;
}

bool CChatSelector::SendMessage(char* message){
	sint16 to = GetCurSel();
	if (to == (-1)){
		return false;
	}
	TCITEM item;
	item.mask = TCIF_PARAM;
	GetItem(to,&item);
	CChatItem* ci = (CChatItem*)item.lParam;
	if (ci->client->GetChatState() == MS_CONNECTING){
		return false;
	}
	if (ci->client->socket && ci->client->socket->IsConnected()){
		uint16 mlen = strlen(message);
		Packet* packet = new Packet(OP_MESSAGE,mlen+2);
		memcpy(packet->pBuffer,&mlen,2);
		memcpy(packet->pBuffer+2,message,mlen);
		ci->client->socket->SendPacket(packet,true,true);
		ci->log->AppendKeyWord(CString(theApp.glob_prefs->GetUserNick()),RGB(1,180,20));
		ci->log->AppendText(CString(": "));
		ci->log->AppendText(CString(message)+CString("\n"));
		chatout.UpdateSize(true);
	}
	else{
		ci->log->AppendKeyWord(CString("*** Connecting..."),RGB(255,0,0));
		ci->messagepending = strdup(message);
		ci->client->SetChatState(MS_CONNECTING);
		ci->client->TryToConnect();
	}
	if (chatout.GetHyperText() == ci->log)
		chatout.UpdateSize(true);
	return true;
}

void CChatSelector::ConnectingResult(CUpDownClient* sender,bool success){
	CChatItem* ci = GetItemByClient(sender);
	if (!ci)
		return;
	ci->client->SetChatState(MS_CHATTING);
	if (!success){
		ci->log->AppendKeyWord(CString(" failed\n"),RGB(255,0,0));
		if (ci->messagepending)
			delete[] ci->messagepending;
		ci->messagepending = 0;
	}
	else{
		ci->log->AppendKeyWord(CString(" ok\n"),RGB(255,0,0));
		uint16 mlen = strlen(ci->messagepending);
		Packet* packet = new Packet(OP_MESSAGE,mlen+2);
		memcpy(packet->pBuffer,&mlen,2);
		memcpy(packet->pBuffer+2,ci->messagepending,mlen);
		ci->client->socket->SendPacket(packet,true,true);
		ci->log->AppendKeyWord(CString(theApp.glob_prefs->GetUserNick()),RGB(1,180,20));
		ci->log->AppendText(CString(": "));
		ci->log->AppendText(CString(ci->messagepending)+CString("\n"));
		delete[] ci->messagepending;
		ci->messagepending = 0;
	}
	if (chatout.GetHyperText() == ci->log)
		chatout.UpdateSize(true);
}

void CChatSelector::DeleteAllItems(){
	for (int i = 0; i != GetItemCount();i++){
		TCITEM cur_item;
		cur_item.mask = TCIF_PARAM;
		GetItem(i,&cur_item);
		delete (CChatItem*)cur_item.lParam;
	}
}

void CChatSelector::OnTimer(UINT_PTR nIDEvent){
	blinkstate = !blinkstate;
	bool globalnotify = false;
	for (int i = 0; i != GetItemCount();i++){
		TCITEM cur_item;
		cur_item.mask = TCIF_PARAM;
		GetItem(i,&cur_item);
		cur_item.mask = TCIF_IMAGE;
		if (((CChatItem*)cur_item.lParam)->notify){
			cur_item.iImage = (blinkstate)? 1:2;
			SetItem(i,&cur_item);
			globalnotify = true;
		}
		else if (cur_item.iImage != 0){
			cur_item.iImage = 0;
			SetItem(i,&cur_item);
		}
	}
	if (globalnotify)
		theApp.emuledlg->ShowMessageState(((blinkstate)? 1:2));
	else
		theApp.emuledlg->ShowMessageState(0);
}



void CChatSelector::ShowChat(){
	if (GetCurSel() == (-1))
		return;
	TCITEM cur_item;
	cur_item.mask = TCIF_PARAM;
	GetItem(GetCurSel(),&cur_item);
	CChatItem* ci = (CChatItem*)cur_item.lParam;
	chatout.SetHyperText(ci->log);
	ci->notify = false;
}


void CChatSelector::OnTcnSelchangeChatsel(NMHDR *pNMHDR, LRESULT *pResult){
	ShowChat();
	*pResult = 0;
}

INT	CChatSelector::InsertItem(int nItem,TCITEM* pTabCtrlItem){
	if (!GetItemCount()){
		WINDOWPLACEMENT wp;
		chatout.GetWindowPlacement(&wp);
		wp.rcNormalPosition.top +=20;
		chatout.SetWindowPlacement(&wp);
	}
	int result = CTabCtrl::InsertItem(nItem,pTabCtrlItem);
	RedrawWindow();
	return result;
}

BOOL CChatSelector::DeleteItem(int nItem){
	CTabCtrl::DeleteItem(nItem);
	if (!GetItemCount()){
		WINDOWPLACEMENT wp;
		chatout.GetWindowPlacement(&wp);
		wp.rcNormalPosition.top -=20;
		chatout.SetWindowPlacement(&wp);
	}
	RedrawWindow();
	return true;
}

void CChatSelector::EndSession(CUpDownClient* client){
	sint16 usedtab;
	if (client){
		usedtab = GetTabByClient(client);
	}
	else{
		usedtab = GetCurSel();
	}
	if (usedtab == (-1))
		return;
	TCITEM item;
	item.mask = TCIF_PARAM;
	GetItem(usedtab,&item);
	CChatItem* ci = (CChatItem*)item.lParam;
	ci->client->SetChatState(MS_NONE);
	
	DeleteItem(usedtab);
	if (chatout.GetHyperText() == ci->log)
		chatout.SetHyperText(0);
	delete ci;
}