//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "StdAfx.h"
#include "updownclient.h"
#include "emule.h"
#include "uploadqueue.h"
#include "Clientlist.h"

//	members of CUpDownClient
//	which are used by down and uploading functions 

CUpDownClient::CUpDownClient(CClientReqSocket* sender){
	socket = sender;
	reqfile = 0;
	Init();
}

CUpDownClient::CUpDownClient(uint16 in_port, uint32 in_userid,uint32 in_serverip, uint16 in_serverport,CPartFile* in_reqfile){
	socket = 0;
	Init();
	userid = in_userid;
	userport = in_port;
	if (!HasLowID())
		sprintf(fulluserip,"%i.%i.%i.%i",(uint8)userid,(uint8)(userid>>8),(uint8)(userid>>16),(uint8)(userid>>24));
	serverip = in_serverip;
	serverport = in_serverport;
	reqfile = in_reqfile;
}

void CUpDownClient::Init(){
	memset(fulluserip,0,21);
	avdowndatarate = 0;
	avupdatarate = 0;
	chatstate = 0;
	dcount = 0;
	maxsendallowed = 0;
	transfered = 0;
	count = 0;
	dataratems = 0;
	datarate = 0;
	username = 0;
	userip = 0;
	userid = 0;
	serverport = 0;
	isbotuser =false;
	isfriend = false;
	useemuleprotocol = false;
	usedcompressiondown = false;
	usedcompressionup = false;
	emuleversion = 0;
	userport = 0;
	partcount = 0;
	partstatus = 0;
	lastaskedtime = 0;
	substate = 0;
	clientfilename = 0;
	upstarttime = 0;
	transfereddown = 0;
	downdatarate = 0;
	downdataratems = 0;
	failedconnection = 0;
	uploadstate = 0;
	lastblockreceived = 0;
	emuleversion = 0;
	datacompression = 0;
	remotequeuerank = 0;
	SetWaitStartTime();
	for (int i = 0;i != 500;i++)
		avarage_udr_list.AddHead((uint32)0);
	for (int i = 0;i != 300;i++)
		avarage_ddr_list.AddHead((uint32)0);
	if (socket){
		SOCKADDR_IN sockAddr;
		memset(&sockAddr, 0, sizeof(sockAddr));
		uint32 nSockAddrLen = sizeof(sockAddr);
		socket->GetPeerName((SOCKADDR*)&sockAddr,(int*)&nSockAddrLen);
		userip = sockAddr.sin_addr.S_un.S_addr;
		strcpy(fulluserip,inet_ntoa(sockAddr.sin_addr));
	}
}

CUpDownClient::~CUpDownClient(){
	//Beep(400,5);
	theApp.clientlist->RemoveClient(this);
	if (clientfilename)
		delete[] clientfilename;
	safe_delete(socket);
	if (username)
		delete[] username;
	if (partstatus)
		delete[] partstatus;
	
	ClearUploadBlockRequests();

	for (POSITION pos = downloadblocks_list.GetHeadPosition();pos != 0;downloadblocks_list.GetNext(pos))
		delete downloadblocks_list.GetAt(pos);
	downloadblocks_list.RemoveAll();
	for (POSITION pos = pendingblocks_list.GetHeadPosition();pos != 0;pendingblocks_list.GetNext(pos)){
		delete pendingblocks_list.GetAt(pos)->block;
		delete pendingblocks_list.GetAt(pos)->buffer;
		delete pendingblocks_list.GetAt(pos);
	}
	pendingblocks_list.RemoveAll();
}

void CUpDownClient::ProcessHelloPacket(char* packet, uint32 size){
	CMemFile* data = new CMemFile((BYTE*)packet,size);
	uint8 hashsize;
	data->Read(&hashsize,1);
	this->ProcessHelloTypePacket(data);
	delete data;
}

void CUpDownClient::ProcessHelloAnswer(char* packet, uint32 size){
	CMemFile* data = new CMemFile((BYTE*)packet,size);
	this->ProcessHelloTypePacket(data);
	delete data;
}

void CUpDownClient::ProcessHelloTypePacket(CMemFile* data){
	data->Read(&userhash,16);
	data->Read(&userid,4);
	data->Read(&userport,2); // hmm clientport is sent twice - why?
	uint32	tagcount;
	data->Read(&tagcount,4);
	for (int i = 0;i != tagcount; i++){
		CTag* temptag = new CTag(data);
		switch(temptag->tag->specialtag){
			case CT_NAME:
				username = strdup(temptag->tag->stringvalue);
				break;
			case CT_VERSION:
				clientversion = temptag->tag->intvalue;
				break;
			case CT_PORT:
				userport = temptag->tag->intvalue;
				break;
		}
		delete temptag;
	}
	data->Read(&serverip,4);
	data->Read(&serverport,2);
}

void CUpDownClient::SendHelloPacket(){
	CMemFile* data = new CMemFile();
	uint8 hashsize = 16;
	data->Write(&hashsize,1);
	SendHelloTypePacket(data);
	Packet* packet = new Packet(data);
	delete data;
	packet->opcode = OP_HELLO;
	if (socket)
		socket->SendPacket(packet,true);
}

void CUpDownClient::SendMuleInfoPacket(bool answer){
	CMemFile* data = new CMemFile();
	uint8 version = CURRENT_VERSION_SHORT;
	data->Write(&version,1);
	uint8 protversion = EMULE_PROTOCOL_VERSION;
	data->Write(&protversion,1);
	uint32 tagcount = 1;
	data->Write(&tagcount,4);
	CTag tag(ET_COMPRESSION,1);
	tag.WriteTagToFile(data);
	Packet* packet = new Packet(data,OP_EMULEPROT);
	delete data;
	if (!answer)
		packet->opcode = OP_EMULEINFO;
	else
		packet->opcode = OP_EMULEINFOANSWER;
	if (socket)
		socket->SendPacket(packet,true,true);
}

void CUpDownClient::ProcessMuleInfoPacket(char* packet, uint32 size){
	CMemFile* data = new CMemFile((BYTE*)packet,size);
	data->Read(&emuleversion,1);
	uint8 protversion;
	data->Read(&protversion,1);
	if (protversion == EMULE_PROTOCOL_VERSION)
		useemuleprotocol = true;
	else{
		delete data;
		return;
	}
	uint32 tagcount;
	data->Read(&tagcount,4);
	for (int i = 0;i != tagcount; i++){
		CTag* temptag = new CTag(data);
		switch(temptag->tag->specialtag){
			case ET_COMPRESSION:
				datacompression = temptag->tag->intvalue;
				break;
		}
		delete temptag;
	}
	delete data;
}

void CUpDownClient::SendHelloAnswer(){
	CMemFile* data = new CMemFile();
	SendHelloTypePacket(data);
	Packet* packet = new Packet(data);
	delete data;
	packet->opcode = OP_HELLOANSWER;
	if (socket)
		socket->SendPacket(packet,true);
}

void CUpDownClient::SendHelloTypePacket(CMemFile* data){
	data->Write(theApp.glob_prefs->GetUserHash(),16);
	uint32 clientid = theApp.serverconnect->GetClientID();
	data->Write(&clientid,4);
	uint16 port = theApp.glob_prefs->GetPort();
	data->Write(&port,2);
	uint32 tagcount = 3;
	data->Write(&tagcount,4);
	CTag* tag = new CTag(CT_NAME,theApp.glob_prefs->GetUserNick());
	tag->WriteTagToFile(data);
	delete tag;
	tag = new CTag(CT_VERSION,EDONKEYVERSION);
	tag->WriteTagToFile(data);
	delete tag;
	tag = new CTag(CT_PORT,theApp.glob_prefs->GetPort());
	tag->WriteTagToFile(data);
	delete tag;
	uint32 ip;
	if (theApp.serverconnect->IsConnected()){
		ip = theApp.serverconnect->GetCurrentServer()->GetIP();
		port = theApp.serverconnect->GetCurrentServer()->GetPort();
	}
	else{
		port = 0;
		ip = 0;
	}
	data->Write(&ip,4);
	data->Write(&port,2);
}
void CUpDownClient::Disconnected(){
	if (GetUploadState() == US_UPLOADING)
		theApp.uploadqueue->RemoveFromUploadQueue(this);
	if (GetDownloadState() == DS_DOWNLOADING){
		SetDownloadState(DS_NONE);
		theApp.downloadqueue->RemoveSource(this);
	}
	//check if this client is needed in any way, if not delete it
	bool del = true;
	switch(uploadstate){
		case US_ONUPLOADQUEUE:
		//case US_UPLOADING:
		//case US_WAITCALLBACK:
			del = false;
	};
	switch(substate){
		case DS_CONNECTING:
		case DS_ONQUEUE:
		case DS_NONEEDEDPARTS:
		case DS_LOWTOLOWIP:
		//case DS_WAITCALLBACK:
			del = false;
	};
	if (GetChatState())
		del = false;

	if (del){
		//theApp.emuledlg->AddLogLine(false,"DEBUG: connection failed");
		delete this;
	}
}

void CUpDownClient::ConnectionFailed(){
	failedconnection++;
	if (failedconnection > MAX_CLIENTCONNECTIONTRY){
		theApp.uploadqueue->RemoveFromUploadQueue(this);
		theApp.uploadqueue->RemoveFromWaitingQueue(this);
		theApp.downloadqueue->RemoveSource(this);
		if (GetChatState() == MS_NONE)
			delete this;
		else
			theApp.emuledlg->chatwnd.chatselector.ConnectingResult(this,false);
	}
	else
		TryToConnect();
	
}

void CUpDownClient::TryToConnect(){
	if ((theApp.serverconnect->GetClientID() < 16777216) && HasLowID()){
		if (GetDownloadState() == DS_CONNECTING)
			SetDownloadState(DS_LOWTOLOWIP);
		else if (GetDownloadState() == DS_REQHASHSET){
			SetDownloadState(DS_ONQUEUE);
			reqfile->hashsetneeded = true;
		}
		if (GetUploadState() == US_CONNECTING){
			theApp.uploadqueue->RemoveFromUploadQueue(this);
			SetUploadState(US_LOWTOLOWIP);
		}
	}

	if (!socket){
		socket = new CClientReqSocket(theApp.glob_prefs,false,this);
		socket->Create();
	}
	else if (!socket->IsConnected()){
		delete socket;
		socket = new CClientReqSocket(theApp.glob_prefs,false,this);
		socket->Create();
	}
	else{
		ConnectionEstablished();
		return;
	}
		
	if (HasLowID()){
		if (GetDownloadState() == DS_CONNECTING)
			SetDownloadState(DS_WAITCALLBACK);
		if (GetUploadState() == US_CONNECTING)
			SetUploadState(US_WAITCALLBACK);

		if (theApp.serverconnect->IsConnected() 
			&& theApp.serverconnect->GetCurrentServer()->GetIP() == serverip){
				Packet* packet = new Packet(OP_CALLBACKREQUEST,4);
				memcpy(packet->pBuffer,&userid,4);
				theApp.serverconnect->SendPacket(packet);
			}
		else{
			in_addr host;
			host.S_un.S_addr = serverip;
			Packet* packet = new Packet(OP_GLOBCALLBACKREQ,10);
			uint32 myip = theApp.serverconnect->GetClientID();
			uint16 myport = theApp.glob_prefs->GetPort();
			memcpy(&packet->pBuffer[0],&myip,4);
			memcpy(&packet->pBuffer[4],&myport,2);
			memcpy(&packet->pBuffer[6],&userid,4);
			theApp.serverconnect->SendUDPPacket(packet,inet_ntoa(host),true);
		}
	}
	else{
		socket->Connect(GetFullIP(),GetUserPort());
		SendHelloPacket();
	}
}

void CUpDownClient::ConnectionEstablished(){
	// ok we have a connection, lets see if we want anything from this client
	if (GetChatState() == MS_CONNECTING)
		theApp.emuledlg->chatwnd.chatselector.ConnectingResult(this,true);
	switch(GetDownloadState()){
		case DS_CONNECTING:
		case DS_WAITCALLBACK:
			SetDownloadState(DS_CONNECTED);
			SendFileRequest();
	}
	uint16 test = GetUploadState();
	switch(GetUploadState()){
		case US_CONNECTING:
		case US_WAITCALLBACK:
			if (theApp.uploadqueue->IsDownloading(this)){
				SetUploadState(US_UPLOADING);
				Packet* packet = new Packet(OP_ACCEPTUPLOADREQ,0);
				socket->SendPacket(packet,true);
			}
	}
}

uint8 CUpDownClient::GetClientSoft(){
	if (!username)
		return SO_UNKNOWN;
	if (userhash[5] == 13 && userhash[14] == 110)
		return SO_OLDEMULE;
	if (userhash[5] == 14 && userhash[14] == 111)
		return SO_EMULE;

	return SO_EDONKEY;
}