//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "AsyncSocketEx.h"
#include "OtherFunctions.h"
#include "ThrottledSocket.h" // ZZ:UploadBandWithThrottler (UDP)

class CAsyncProxySocketLayer;
class Packet;

#define ERR_WRONGHEADER		0x01
#define ERR_TOOBIG			0x02

#define	ES_DISCONNECTED		0xFF
#define	ES_NOTCONNECTED		0x00
#define	ES_CONNECTED		0x01

#define PACKET_HEADER_SIZE	6

struct StandardPacketQueueEntry {
    uint32 actualPayloadSize;
    Packet* packet;
};

//MOPRH START - Changed by SiRoB, zz Upload System
/*
class CEMSocket : public CAsyncSocketEx
*/
class CEMSocket : public CAsyncSocketEx, public ThrottledFileSocket // ZZ:UploadBandWithThrottler (UDP)
//MOPRH END   - Changed by SiRoB, zz Upload System
{
//MOPRH START - Removed by SiRoB, zz Upload System
//    friend class UploadBandwidthThrottler;
//MOPRH END   - Removed by SiRoB, zz Upload System
public:
	CEMSocket(void);
	~CEMSocket(void);

	//MOPRH START - Changed by SiRoB, zz Upload System
	/*
	void 	SendPacket(Packet* packet, bool delpacket = true, bool controlpacket = true, uint32 actualPayloadSize = 0);
	*/
	virtual void 	SendPacket(Packet* packet, bool delpacket = true, bool controlpacket = true, uint32 actualPayloadSize = 0);
	//MOPRH END   - Changed by SiRoB, zz Upload System
    bool    HasQueues();
    bool	IsConnected() const {return byConnected == ES_CONNECTED;}
	uint8	GetConState() const {return byConnected;}
	void	SetDownloadLimit(uint32 limit);
	void	DisableDownloadLimit();
	BOOL	AsyncSelect(long lEvent);

	// deadlake PROXYSUPPORT
	// By Maverick: Connection necessary initalizing calls are done by class itself and not anymore by the Owner
	virtual BOOL Connect(LPCTSTR lpszHostAddress, UINT nHostPort);
	virtual BOOL Connect(SOCKADDR* pSockAddr, int iSockAddrLen);
	void InitProxySupport();
	// Reset Layer Chain
	virtual void RemoveAllLayers();

    //DWORD   GetLastSendLatency() { return (m_Average_sendlatency_list.GetCount() > 0)?(m_Average_sendlatency_list.GetTail().latency):0; }
    //DWORD   GetAverageLatency() { return (m_Average_sendlatency_list.GetCount() > 0)?(m_latency_sum/m_Average_sendlatency_list.GetCount()):0; }

    DWORD GetLastCalledSend() { return lastCalledSend; }

    uint64 GetSentBytesCompleteFileSinceLastCallAndReset();
    uint64 GetSentBytesPartFileSinceLastCallAndReset();
    uint64 GetSentBytesControlPacketSinceLastCallAndReset();
    uint64 GetSentPayloadSinceLastCallAndReset();
    void TruncateQueues();

	//MOPRH START - Added by SiRoB, zz Upload System
	virtual SocketSentBytes Send(uint32 maxNumberOfBytesToSend, uint32 minFragSize, bool onlyAllowedToSendControlPacket);
    uint32	GetNeededBytes();
 	//MOPRH END   - Added by SiRoB, zz Upload System
#ifdef _DEBUG
	// Diagnostic Support
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	virtual int	OnLayerCallback(const CAsyncSocketExLayer *pLayer, int nType, int nParam1, int nParam2);	// deadlake PROXYSUPPORT
	virtual bool	PacketReceived(Packet* packet) = 0;
	virtual void	OnError(int nErrorCode) = 0;
	virtual void	OnClose(int nErrorCode);
	virtual void	OnSend(int nErrorCode);	
	virtual void	OnReceive(int nErrorCode);

	uint8	byConnected;

	// deadlake PROXYSUPPORT
	bool	m_ProxyConnectFailed;
	CAsyncProxySocketLayer* m_pProxyLayer;
//MOPRH START - Removed by SiRoB, zz Upload System
//    virtual SocketSentBytes Send(uint32 maxNumberOfBytesToSend, bool onlyAllowedToSendControlPacket = false);
//MOPRH END   - Removed by SiRoB, zz Upload System
private:
	void	ClearQueues();	
	virtual int Receive(void* lpBuf, int nBufLen, int nFlags = 0);

    //MOPRH START - Added by SiRoB, zz Upload System
	uint32 GetNextFragSize(uint32 current, uint32 minFragSize);
	bool    HasSent() { return m_hasSent; }
	//MOPRH END   - Added by SiRoB, zz Upload System

	// Download (pseudo) rate control	
	uint32	downloadLimit;
	bool	downloadLimitEnable;
	bool	pendingOnReceive;

	// Download partial header
	char*	pendingHeader[PACKET_HEADER_SIZE];      
	uint32	pendingHeaderSize;

	// Download partial packet
	Packet* pendingPacket;
	uint32  pendingPacketSize;

	// Upload control
	char*	sendbuffer;
	uint32	sendblen;
	uint32	sent;

	CTypedPtrList<CPtrList, Packet*> controlpacket_queue;
	CList<StandardPacketQueueEntry, StandardPacketQueueEntry> standartpacket_queue;

    bool m_currentPacket_is_controlpacket;

    CCriticalSection sendLocker;
    //uint64 m_controlSize;
    //uint64 m_standardSize;

    uint64 m_numberOfSentBytesCompleteFile;
    uint64 m_numberOfSentBytesPartFile;
    uint64 m_numberOfSentBytesControlPacket;
    bool m_currentPackageIsFromPartFile;

	bool	m_bAccelerateUpload; //MOPRH - Added by SiRoB, zz Upload System
    DWORD lastCalledSend;
	uint32	lastFinishedStandard; //MOPRH - Added by SiRoB, zz Upload System

    //void StoppedSendSoUpdateStats();
    //void CleanSendLatencyList();
    //DWORD   m_startSendTick;
    //CList<SocketTransferStats,SocketTransferStats>	m_Average_sendlatency_list;
    //DWORD   m_lastSendLatency;
    //uint32 m_latency_sum;
    //bool m_wasBlocked;

    uint32 m_actualPayloadSize;
    uint32 m_actualPayloadSizeSent;
	//MOPRH - Added by SiRoB, zz Upload System
    boolean m_bBusy;
	boolean m_hasSent;
	//MOPRH - Added by SiRoB, zz Upload System
};
